<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\Cate;
use App\Models\Category;
use App\Models\Certificate;
use App\Models\User;
use App\Models\WebAbout;
use App\Models\WebContact;
use App\Models\WebDonation;
use App\Models\WebHome;
use App\Models\WebProject;
use App\Models\Websettings;
use App\Models\Donation;
use Dom\Document;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;
use Carbon\Carbon;

use Illuminate\Http\Request;

class BlogsController extends Controller
{
    public function home()
    {
        $category = Category::where('status', 'Active')
            ->orderBy('created_at', 'desc')
            ->get();

        $blogs = Blog::with('authorDetail') // <-- this is the fix
            ->where('is_feature', 'Active')
            ->orderBy('created_at', 'desc')
            ->get();
        return view('front.blog', [
            'title' => 'Our Blogs',
            'category' => $category,
            'blogs' => $blogs
        ]);
    }

    // Show single blog by slug
    public function show($slug)
    {
        $category = Category::where('status', 'Active')
            ->orderBy('created_at', 'desc')
            ->get();

        $blog = Blog::with('authorDetail')->where('slug', $slug)
            ->where('is_feature', 'Active')
            ->firstOrFail();

        return view('front.blog-details', [
            'title' => $blog->title,
            'blog' => $blog,
            'category' => $category
        ]);
    }


}
