<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Blog;
use App\Models\Cate;
use App\Models\Category;
use App\Models\Certificate;
use App\Models\ContactMessage;
use App\Models\User;
use App\Models\WebAbout;
use App\Models\WebContact;
use App\Models\WebDonation;
use App\Models\WebHome;
use App\Models\WebProject;
use App\Models\Websettings;
use App\Models\Donation;
use Dom\Document;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;
use Carbon\Carbon;

use Illuminate\Http\Request;

class ContactController extends Controller
{
    //Home starts now
    public function home()
    {
        $contactData = WebContact::all();
        $webData = Websettings::all();

        return view('front.contact', [
            'title' => 'Contact Us',
            'contactData' => $contactData,
            'webData' => $webData
        ]);
    }
    public function contactMessageStore(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'nullable|string|max:20',

        ]);
        ContactMessage::create([
            'name' => $validated['name'],
            'email' => $validated['email'],
            'phone' => $validated['phone'],
            'message' => $request->input('message')
        ]);
        return response()->json(['success' => true]);

    }

}
