<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Video;
use App\Models\WebHome;
use App\Models\Certificate;
use App\Models\Blog;
use Dom\Document;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;
use Carbon\Carbon;

use Illuminate\Http\Request;

class HomeController extends Controller
{
    //Home starts now
    public function home()
    {
        $sections = WebHome::orderBy('id', 'asc')->get();
        $certificates = Certificate::where('status', 'Active')
            ->where('is_feature', 'Active')
            ->latest()
            ->get();

        $blogs = Blog::with('authorDetail') // <-- this is the fix
            ->where('is_feature', 'Active')
            ->orderBy('created_at', 'desc')
            ->get();
        $video = Video::where('is_feature', '1')->orderBy('created_at', 'desc')->get();
        return view('front.index', [
            'title' => 'Home',
            'sections' => $sections,
            'certificates' => $certificates,
            'blogs' => $blogs,
            'video' => $video
        ]);
    }




}
