<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    protected $table = 'blogs';

    protected $fillable = [
        'title',
        'slug',
        'category_id',
        'image',
        'description',
        'author',
        'tag',
        'schedule_date',
        'is_feature',
    ];

    protected $casts = [
        'description' => 'encrypted',
        'schedule_date' => 'datetime',
    ];

    // Proper relationship: a blog belongs to a category
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }

    // Proper relationship: a blog belongs to an author (user)
    public function authorDetail()
    {
        return $this->belongsTo(User::class, 'author', 'id');
    }
}
