<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Schema; // ✅ Add this
use App\Models\Websettings;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // ✅ Only fetch websettings if the table exists
        if (Schema::hasTable('websettings')) {
            $websettings = Websettings::first();
            View::share('websettings', $websettings);
        }
    }
}
