<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->string('image')->nullable();
            $table->text('description')->nullable();
            $table->unsignedBigInteger('author')->nullable();
            $table->string('tag')->nullable();
            $table->dateTime('schedule_date')->nullable();
            $table->string('is_feature')->default("Active");
            $table->timestamps();

            // Optional: Add foreign keys if you have `categories` and `users` tables
            // $table->foreign('category_id')->references('id')->on('categories')->onDelete('set null');
            // $table->foreign('author')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
