(function ($) {
    "use strict";

    // ---------- VISIT-SALE CHART ----------
    const visitChartElement = document.getElementById("visit-sale-chart");
    if (visitChartElement) {
        const graphCtx = visitChartElement.getContext("2d");

        const gradient1 = graphCtx.createLinearGradient(0, 0, 0, 181);
        gradient1.addColorStop(0, "rgba(218, 140, 255, 1)");
        gradient1.addColorStop(1, "rgba(154, 85, 255, 1)");

        const gradient2 = graphCtx.createLinearGradient(0, 0, 0, 150);
        gradient2.addColorStop(0, "rgba(54, 215, 232, 1)");
        gradient2.addColorStop(1, "rgba(177, 148, 250, 1)");

        const gradient3 = graphCtx.createLinearGradient(0, 0, 0, 181);
        gradient3.addColorStop(0, "rgba(255, 191, 150, 1)");
        gradient3.addColorStop(1, "rgba(254, 112, 150, 1)");

        const visitChart = new Chart(graphCtx, {
            type: "bar",
            data: {
                labels: ["JAN", "FEB", "MAR", "APR", "MAY", "JUN"],
                datasets: [
                    {
                        label: "CHN",
                        backgroundColor: gradient1,
                        data: [100, 200, 300, 400, 500, 600],
                    },
                    {
                        label: "USA",
                        backgroundColor: gradient2,
                        data: [80, 120, 180, 240, 300, 360],
                    },
                    {
                        label: "UK",
                        backgroundColor: gradient3,
                        data: [60, 100, 140, 180, 220, 260],
                    },
                ],
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { display: false },
                },
                scales: {
                    x: {
                        stacked: true,
                        grid: { display: false },
                        ticks: {
                            font: {
                                size: 13,
                                family: "Poppins",
                            },
                        },
                    },
                    y: {
                        stacked: true,
                        ticks: {
                            beginAtZero: true,
                            stepSize: 100,
                            font: {
                                size: 13,
                                family: "Poppins",
                            },
                        },
                    },
                },
            },
            plugins: [
                {
                    afterUpdate: function (chart) {
                        const legendId = `${chart.canvas.id}-legend`;
                        const legendContainer =
                            document.getElementById(legendId);
                        if (!legendContainer) return;
                        legendContainer.innerHTML = "";
                        const ul = document.createElement("ul");
                        chart.data.datasets.forEach((ds) => {
                            const li = document.createElement("li");
                            li.innerHTML = `<span style="background-color: ${ds.backgroundColor}"></span> ${ds.label}`;
                            ul.appendChild(li);
                        });
                        legendContainer.appendChild(ul);
                    },
                },
            ],
        });
    }

    // ---------- TRAFFIC CHART ----------
    const trafficChartElement = document.getElementById("traffic-chart");
    if (trafficChartElement) {
        const trafficCtx = trafficChartElement.getContext("2d");

        const gradient1 = trafficCtx.createLinearGradient(0, 0, 0, 181);
        gradient1.addColorStop(0, "rgba(54, 215, 232, 1)");
        gradient1.addColorStop(1, "rgba(177, 148, 250, 1)");

        const gradient2 = trafficCtx.createLinearGradient(0, 0, 0, 150);
        gradient2.addColorStop(0, "rgba(6, 185, 157, 1)");
        gradient2.addColorStop(1, "rgba(132, 217, 210, 1)");

        const gradient3 = trafficCtx.createLinearGradient(0, 0, 0, 300);
        gradient3.addColorStop(0, "rgba(254, 112, 150, 1)");
        gradient3.addColorStop(1, "rgba(255, 191, 150, 1)");

        new Chart(trafficCtx, {
            type: "doughnut",
            data: {
                labels: ["Search Engines", "Direct Click", "Bookmarks Click"],
                datasets: [
                    {
                        data: [30, 30, 40],
                        backgroundColor: [gradient1, gradient2, gradient3],
                        borderColor: [
                            "transparent",
                            "transparent",
                            "transparent",
                        ],
                    },
                ],
            },
            options: {
                responsive: true,
                cutout: "75%",
                plugins: {
                    legend: { display: false },
                },
            },
            plugins: [
                {
                    afterUpdate: function (chart) {
                        const legendId = `${chart.canvas.id}-legend`;
                        const legendContainer =
                            document.getElementById(legendId);
                        if (!legendContainer) return;
                        legendContainer.innerHTML = "";
                        const ul = document.createElement("ul");
                        chart.data.labels.forEach((label, i) => {
                            const li = document.createElement("li");
                            li.innerHTML = `<span style="background-color: ${chart.data.datasets[0].backgroundColor[i]}"></span> ${label}`;
                            ul.appendChild(li);
                        });
                        legendContainer.appendChild(ul);
                    },
                },
            ],
        });
    }

    // ---------- DATEPICKER ----------
    if ($("#inline-datepicker").length) {
        $("#inline-datepicker").datepicker({
            enableOnReadonly: true,
            todayHighlight: true,
        });
    }

    // ---------- PRO BANNER HANDLER ----------
    if ($("#proBanner").length) {
        const isBannerClosed = $.cookie("majestic-free-banner") === "true";
        if (!isBannerClosed) {
            $("#proBanner").removeClass("d-none");
            $(".navbar").removeClass("fixed-top").addClass("pt-5");
            $(".page-body-wrapper").removeClass("pt-0");
        }

        $("#bannerClose").on("click", function () {
            $("#proBanner").addClass("d-none");
            $(".navbar").removeClass("pt-5").addClass("fixed-top");
            $(".page-body-wrapper").removeClass("pt-0");
            $.cookie("majestic-free-banner", "true", { expires: 1, path: "/" });
        });
    }
})(jQuery);
