@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title"> Add Blog </h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('blog') }}">Blog</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Add Blog</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Add</h1>

                <form class="forms-sample" method="POST" action="{{ route('blog.store') }}" enctype="multipart/form-data">
                    @csrf

                    <div class="form-group">
                        <label for="exampleInputName1">Title</label>
                        <input type="text" class="form-control" id="exampleInputName1" placeholder="Enter Blog Title"
                            name="title" value="{{ old('title') }}">
                        @error('title')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="exampleInputName1">Slug</label>
                        <input type="text" class="form-control" id="slug" name="slug"
                            placeholder="Slug will be auto-generated" value="{{ old('slug') }}" readonly>
                        <!-- Make it readonly -->
                    </div>

                    <div class="form-group">
                        <label for="exampleSelectGender">Category</label>
                        <select class="form-select" name="category_id" id="exampleSelectGender">
                            @foreach ($categories as $category)
                                <option value="{{ $category->id }}">{{ $category->name }}</option>

                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Feature Image</label>
                        <input type="file" name="image" class="file-upload-default" id="fileInput">

                        <div class="input-group col-xs-12">
                            <input type="text" class="form-control file-upload-info" disabled placeholder="Upload Image">
                            <span class="input-group-append">
                                <button class="file-upload-browse btn btn-gradient-primary py-3" type="button"
                                    onclick="document.getElementById('fileInput').click();">
                                    Upload
                                </button>
                            </span>
                        </div>

                        <!-- Image Preview Area -->
                        <div id="preview" style="margin-top: 10px;">
                            <img id="previewImage" src="" alt="Preview"
                                style="max-width: 200px; display: none; border: 1px solid #ccc; padding: 5px;" />
                        </div>
                        @error('image')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description"
                            vlaue="{{ old('description') }}"></textarea>
                        @error('description')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror


                    </div>

                    <div class="form-group">
                        <label for="user_id">Author</label>
                        <select class="form-select" id="user_id" name="author">
                            @foreach ($users as $user)
                                <option value="{{ $user->id }}" {{ (old('user_id', auth()->user()->id) == $user->id) ? 'selected' : '' }}>
                                    {{ $user->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('user_id')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>


                    <div class="form-group">
                        <label for="tag">Tag</label>
                        <input type="text" class="form-control" id="tag" name="tag" value="{{ old('tag') }}">
                        @error('tag')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="schedule_date">Schedule Blog Publish Date & Time</label>
                        <input type="datetime-local" class="form-control" id="schedule_date" name="schedule_date"
                            value="{{ old('schedule_date') }}">
                    </div>

                    <div class="form-group">
                        <label for="is_feature">Is Feature</label>
                        <select class="form-select" id="is_feature" name="is_feature">
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-gradient-primary me-2">Submit</button>
                    <button class="btn btn-light">Cancel</button>
                </form>

            </div>
        </div>

    </div>




@endsection
@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const fileInput = document.getElementById('fileInput');
            const previewImage = document.getElementById('previewImage');
            const fileUploadInfo = document.querySelector('.file-upload-info');

            if (fileInput && previewImage && fileUploadInfo) {
                fileInput.addEventListener('change', function () {
                    const file = this.files[0];
                    if (file) {
                        const reader = new FileReader();

                        reader.onload = function (e) {
                            previewImage.setAttribute('src', e.target.result);
                            previewImage.style.display = 'block';
                            fileUploadInfo.value = file.name;
                        }

                        reader.readAsDataURL(file);
                    }
                });
            }
        });
    </script>
@endpush