@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title"> Blog Edit </h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('blog') }}">Blog</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Edit Blog</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Edit</h1>

                <form class="forms-sample" method="POST" action="{{ route('blog.update', $blog->id) }}"
                    enctype="multipart/form-data">
                    @csrf
                    @method('PUT') <!-- Important for PUT method -->

                    <div class="form-group">
                        <label for="exampleInputName1">Title</label>
                        <input type="text" class="form-control" name="title" value="{{ old('title', $blog->title) }}">
                        @error('title') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <div class="form-group">
                        <label for="slug">Slug</label>
                        <input type="text" class="form-control" id="slug" name="slug" value="{{ old('slug', $blog->slug) }}"
                            readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleSelectGender">Category</label>
                        <select class="form-select" name="category_id">
                            @foreach ($categories as $category)
                                <option value="{{ $category->id }}" {{ $category->id == $blog->category_id ? 'selected' : '' }}>
                                    {{ $category->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Feature Image</label>
                        <input type="file" name="image" class="file-upload-default" id="fileInput">

                        <div class="input-group col-xs-12">
                            <input type="text" class="form-control file-upload-info" disabled placeholder="Upload Image">
                            <span class="input-group-append">
                                <button class="file-upload-browse btn btn-gradient-primary py-3" type="button"
                                    onclick="document.getElementById('fileInput').click();">Upload</button>
                            </span>
                        </div>

                        <div id="preview" style="margin-top: 10px;">
                            @if (!empty($blog->image))
                                <img id="previewImage" src="{{ asset('uploads/blog/' . $blog->image) }}" alt="Preview"
                                    style="max-width: 200px; border: 1px solid #ccc; padding: 5px;" />
                            @else
                                <img id="previewImage" src="" alt="Preview" style="max-width: 200px; display: none;" />
                            @endif
                        </div>

                        @error('image')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>


                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description"
                            name="description">{{ old('description', $blog->description) }}</textarea>
                        @error('description') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <div class="form-group">
                        <label for="user_id">Author</label>
                        <select class="form-select" id="user_id" name="author">
                            @foreach ($users as $user)
                                <option value="{{ $user->id }}" {{ $blog->author == $user->id ? 'selected' : '' }}>
                                    {{ $user->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="tag">Tag</label>
                        <input type="text" class="form-control" id="tag" name="tag" value="{{ old('tag', $blog->tag) }}">
                    </div>

                    <div class="form-group">
                        <label for="schedule_date">Schedule Blog Publish Date & Time</label>
                        <input type="datetime-local" class="form-control" id="schedule_date" name="schedule_date"
                            value="{{ old('schedule_date', \Carbon\Carbon::parse($blog->schedule_date)->format('Y-m-d\TH:i')) }}">
                    </div>

                    <div class="form-group">
                        <label for="is_feature">Is Feature</label>
                        <select class="form-select" id="is_feature" name="is_feature">
                            <option value="Active" {{ $blog->is_feature === 'Active' ? 'selected' : '' }}>Active</option>
                            <option value="Inactive" {{ $blog->is_feature === 'Inactive' ? 'selected' : '' }}>Inactive
                            </option>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-gradient-primary me-2">Update</button>
                    <a href="{{ route('blog') }}" class="btn btn-light">Cancel</a>
                </form>

            </div>
        </div>

    </div>



@endsection
@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const fileInput = document.getElementById('fileInput');
            const previewImage = document.getElementById('previewImage');
            const fileUploadInfo = document.querySelector('.file-upload-info');

            if (fileInput && previewImage && fileUploadInfo) {
                fileInput.addEventListener('change', function () {
                    const file = this.files[0];
                    if (file) {
                        const reader = new FileReader();

                        reader.onload = function (e) {
                            previewImage.setAttribute('src', e.target.result);
                            previewImage.style.display = 'block';
                            fileUploadInfo.value = file.name;
                        }

                        reader.readAsDataURL(file);
                    }
                });
            }
        });
    </script>
@endpush