@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Create Category</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('category') }}">Category</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Create Category</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Create</h1>

                <form class="forms-sample" method="POST" action="{{ route('category.store') }}"
                    enctype="multipart/form-data">
                    @csrf

                    <div class="form-group">
                        <label for="exampleInputName1">Category Name</label>
                        <input type="text" class="form-control" id="exampleInputName1" placeholder="Enter Name" name="name"
                            value="{{ old('name') }}">
                        @error('name')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="exampleInputName1">Slug</label>
                        <input type="text" class="form-control" id="slug" name="slug"
                            placeholder="Slug will be auto-generated" value="{{ old('slug') }}" readonly>
                        <!-- Make it readonly -->
                    </div>

                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description"
                            vlaue="{{ old('description') }}"></textarea>
                        @error('description')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror


                    </div>

                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-gradient-primary me-2">Submit</button>
                    <button class="btn btn-light">Cancel</button>
                </form>

            </div>
        </div>

    </div>



@endsection