@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Edit Certificate</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('certificate') }}">Certificate</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Edit Certificate</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <form class="forms-sample" action="{{ route('certificate.update', $certificate->id) }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="form-group">
                        <label for="exampleInputName1">Title</label>
                        <input type="text" class="form-control" id="exampleInputName1" placeholder="Enter Heading"
                            name="title" value="{{ old('title', $certificate->title) }}">
                        @error('title')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    {{-- Certificate Image --}}
                    <div class="form-group">
                        <label for="certificate_image"> </label>
                        <input type="file" name="certificate_image" id="certificate_image" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'preview_certificate')">
                        <small class="text-muted">Recommended size: 500x500 px</small>
                        <br>
                        <img src="{{ asset('uploads/certificates/' . $certificate->certificate_image) }}"
                            id="preview_certificate" class="img-fluid mt-2" style="max-height: 200px;">
                    </div>
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description"
                            vlaue="{{ old('description') }}">{{ old('description', $certificate->description) }}</textarea>
                        @error('description')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror

                    </div>
                    {{-- feature --}}
                    <div class="form-group">
                        <label for="is_feature">Is Feature</label>
                        <select class="form-select" id="is_feature" name="is_feature">
                            <option value="Active" {{ $certificate->is_feature == 'Active' ? 'selected' : '' }}>Active
                            </option>
                            <option value="Inactive" {{ $certificate->is_feature == 'Inactive' ? 'selected' : '' }}>Inactive
                            </option>
                        </select>
                    </div>
                    {{-- status --}}
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="Active" {{ $certificate->status == 'Active' ? 'selected' : '' }}>Active</option>
                            <option value="Inactive" {{ $certificate->status == 'Inactive' ? 'selected' : '' }}>Inactive
                            </option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Update Certificate</button>
                </form>
            </div>
        </div>
    </div>


    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

@endsection