@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title"> Impact</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('certificate.create') }}" class="btn btn-info">Add
                            Impact</a></li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Impact</h1>


                @if(Session::has('status'))
                    <p class="alert alert-success">{{ Session::get('status') }}</p>
                @endif
                <table id="categoryTable" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Impact Name</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>

            </div>
        </div>

    </div>


    @push('scripts')
        <script>
            $(document).ready(function () {
                $('#categoryTable').DataTable({
                    autoWidth: true, // Let DataTables calculate column widths
                    responsive: true, // Optional, better behavior on small screens
                    processing: true,
                    serverSide: false, // optional for small datasets
                    ajax: '{{ route("admin.certificate.data") }}',
                    order: [],
                    columns: [
                        { data: 0 },
                        { data: 1 },
                        { data: 2 },
                        { data: 3 }


                    ]
                });
            });
        </script>
        <script>
            $(document).on('change', '.certificate-status', function (e) {
                e.preventDefault();

                let id = $(this).data('id');
                let status = $(this).val();

                $.ajax({
                    url: "{{ route('admin.certificate.updateStatus') }}",
                    type: "POST",
                    data: {
                        _token: '{{ csrf_token() }}',
                        id: id,
                        status: status
                    },
                    success: function (response) {
                        Swal.fire({
                            title: 'Status Updated',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'OK'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                location.reload();
                            }
                        });
                    },
                    error: function (xhr) {
                        Swal.fire({
                            title: 'Error',
                            text: 'Something went wrong!',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                });
            });
        </script>
        <script>
            $(document).on('click', '.editBtn', function () {
                let id = $(this).data('id');
                window.location.href = 'certificate/edit/' + id;
            });
        </script>
        <script>
            $(document).on('click', '.deleteBtn', function () {
                const categoryId = $(this).data('id');

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: `/admin/certificate/delete/${categoryId}`,
                            type: 'DELETE',
                            data: {
                                _token: '{{ csrf_token() }}'
                            },
                            success: function (response) {
                                Swal.fire(
                                    'Deleted!',
                                    response.message,
                                    'success'
                                ).then(() => {
                                    location.reload();
                                });
                            },
                            error: function () {
                                Swal.fire(
                                    'Error!',
                                    'There was a problem deleting the certificate.',
                                    'error'
                                );
                            }
                        });
                    }
                });
            });
        </script>


    @endpush



@endsection