@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title"> Customer Inquiries
            </h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}" class="btn btn-info">
                            Dashboard</a></li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Contact Message List</h1>

                <table id="contactmTable" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Name</th>
                            <th>email</th>
                            <th>phone</th>
                            <th>Message</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                </table>

            </div>
        </div>

    </div>

    @push('scripts')
        <script>
            $(document).ready(function () {
                $('#contactmTable').DataTable({
                    autoWidth: true, // Let DataTables calculate column widths
                    responsive: true, // Optional, better behavior on small screens
                    processing: true,
                    serverSide: false, // optional for small datasets
                    ajax: '{{ route("admin.contact.message") }}',
                    order: [],
                    columns: [
                        { data: 0 },
                        { data: 1 },
                        { data: 2 },
                        { data: 3 },
                        { data: 4 },
                        { data: 5 }


                    ]
                });
            });
        </script>





    @endpush

@endsection