@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title"> Donations</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}" class="btn btn-info">Dashboard</a></li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Donations</h1>


                @if(Session::has('status'))
                    <p class="alert alert-success">{{ Session::get('status') }}</p>
                @endif
                <table id="donationTable" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Name</th>
                            <th>phone</th>
                            <th>Amount</th>
                            <th>Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>

            </div>
        </div>

    </div>

    @push('scripts')
        <script>
            $(document).ready(function () {
                $('#donationTable').DataTable({
                    autoWidth: true,
                    responsive: true,
                    processing: true,
                    serverSide: false, // okay for small datasets
                    ajax: '{{ route("admin.donation.data") }}',
                    order: [],
                    columns: [
                        { data: 'sl_no' },
                        { data: 'name' },
                        { data: 'phone' },
                        { data: 'amount' },
                        { data: 'payment_date' },
                        { data: 'actions', orderable: false, searchable: false }
                    ]
                });
            });
        </script>






    @endpush

@endsection