@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Add Certificate</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('certificate') }}">Certificate</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Add Certificate</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ route('certificate.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                        <label for="exampleInputName1">Title</label>
                        <input type="text" class="form-control" id="exampleInputName1" placeholder="Enter Heading"
                            name="title" value="{{ old('title') }}">
                        @error('title')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    {{-- Certificate Image --}}
                    <div class="form-group">
                        <label for="certificate_image"> </label>
                        <input type="file" name="certificate_image" id="certificate_image" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'preview_certificate')">
                        <small class="text-muted">Recommended size: 500x500 px</small>
                        <img id="preview_certificate" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description"
                            vlaue="{{ old('description') }}"></textarea>
                        @error('description')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror

                    </div>
                    {{-- feature --}}
                    <div class="form-group">
                        <label for="is_feature">Is Feature</label>
                        <select class="form-select" id="is_feature" name="is_feature">
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>
                        </select>
                    </div>
                    {{-- status --}}
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>
                        </select>
                    </div>



                    <button type="submit" class="btn btn-primary">Add Certificate</button>
                </form>
            </div>
        </div>
    </div>


    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

@endsection