@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">View Users</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('users') }}">Users</a></li>
                    <li class="breadcrumb-item active" aria-current="page">View Users</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                    @csrf
                    @method('PUT')
                    <div class="form-group">
                        <label for="exampleInputName1">Name</label>
                        <p><b>{{ old('first_name', $donation->first_name) }} {{ old('last_name', $donation->last_name) }}</b></p>
                    </div>
                    
                    <div class="form-group">
                        <label for="exampleInputName1">Email</label>
                        <p><b>{{ old('email', $donation->email) }}</b></p>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputName1">Phone</label>
                        <p><b>{{ old('phone', $donation->phone) }}</b></p>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputName1">Amount</label>
                        <p><b>{{ old('amount', $donation->amount) }}</b></p>
                    </div>


                    <div class="form-group">
                        <label for="exampleInputName1">Date</label>
                        <p><b>{{ old('created_at', \Carbon\Carbon::parse($donation->created_at)->format('d-m-Y h:i A')) }}</b></p>
                    </div>

            </div>
        </div>
    </div>

@endsection