@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title"> Users</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="#" onclick="exportTableToExcel('categoryTable', 'donations')" class="btn btn-info">Export Users</a></li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Users List</h1>


                @if(Session::has('status'))
                    <p class="alert alert-success">{{ Session::get('status') }}</p>
                @endif
                <table id="categoryTable" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>User Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Amount</th>
                            <th>Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>

            </div>
        </div>

    </div>


    @push('scripts')
        <script>
            $(document).ready(function () {
                $('#categoryTable').DataTable({
                    autoWidth: true, // Let DataTables calculate column widths
                    responsive: true, // Optional, better behavior on small screens
                    processing: true,
                    serverSide: false, // optional for small datasets
                    ajax: '{{ route("admin.users.data") }}',
                    order: [],
                    columns: [
                        { data: 0 },
                        { data: 1 },
                        { data: 2 },
                        { data: 3 },
                        { data: 4 },
                        { data: 5 },
                        { data: 6 }
                    ]
                });
            });
        </script>
        <script>
            $(document).on('change', '.certificate-status', function (e) {
                e.preventDefault();

                let id = $(this).data('id');
                let status = $(this).val();

                $.ajax({
                    url: "{{ route('admin.certificate.updateStatus') }}",
                    type: "POST",
                    data: {
                        _token: '{{ csrf_token() }}',
                        id: id,
                        status: status
                    },
                    success: function (response) {
                        Swal.fire({
                            title: 'Status Updated',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'OK'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                location.reload();
                            }
                        });
                    },
                    error: function (xhr) {
                        Swal.fire({
                            title: 'Error',
                            text: 'Something went wrong!',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                });
            });
        </script>
        <script>
            $(document).on('click', '.editBtn', function () {
                let id = $(this).data('id');
                window.location.href = 'users/edit/' + id;
            });
        </script>
        <script>
            $(document).on('click', '.deleteBtn', function () {
                const categoryId = $(this).data('id');

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: `/admin/users/delete/${categoryId}`,
                            type: 'DELETE',
                            data: {
                                _token: '{{ csrf_token() }}'
                            },
                            success: function (response) {
                                Swal.fire(
                                    'Deleted!',
                                    response.message,
                                    'success'
                                ).then(() => {
                                    location.reload();
                                });
                            },
                            error: function () {
                                Swal.fire(
                                    'Error!',
                                    'There was a problem deleting the user.',
                                    'error'
                                );
                            }
                        });
                    }
                });
            });
        </script>

        <script>
function exportTableToExcel(tableID, filename = '') {
    const dataType = 'application/vnd.ms-excel';
    const table = document.getElementById(tableID);
    let tableHTML = '<table>';

    // Extract rows from the table
    const rows = table.querySelectorAll('tr');

    rows.forEach(row => {
        tableHTML += '<tr>';
        const cells = row.querySelectorAll('th, td');
        for (let i = 0; i < cells.length - 1; i++) { // skip the last cell (index 6)
            tableHTML += '<td>' + cells[i].innerText + '</td>';
        }
        tableHTML += '</tr>';
    });

    tableHTML += '</table>';

    filename = filename ? filename + '.xls' : 'export.xls';

    const downloadLink = document.createElement("a");
    document.body.appendChild(downloadLink);

    if (navigator.msSaveOrOpenBlob) {
        const blob = new Blob(['\ufeff', tableHTML], { type: dataType });
        navigator.msSaveOrOpenBlob(blob, filename);
    } else {
        downloadLink.href = 'data:' + dataType + ', ' + encodeURIComponent(tableHTML);
        downloadLink.download = filename;
        downloadLink.click();
    }

    document.body.removeChild(downloadLink);
}
</script>




    @endpush



@endsection