@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">{{ isset($video) ? 'Edit' : 'Add' }} Video</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin.video') }}">Video</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ isset($video) ? 'Edit' : 'Add' }} Video</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ isset($video) ? route('admin.video.update', $video->_id) : route('admin.video.store') }}"
                    method="POST">
                    @csrf
                    @if(isset($video))
                        @method('PUT')
                    @endif

                    <div class="form-group">
                        <label for="video_link">Video URL</label>
                        <input type="url" name="video_link" id="video_link" class="form-control"
                            placeholder="Enter YouTube/Vimeo URL" value="{{ old('video_link', $video->video_link ?? '') }}"
                            required>
                        @error('video_link')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="is_feature">Is Feature</label>
                        <select name="is_feature" id="is_feature" class="form-select">
                            <option value="1" {{ old('is_feature', $video->is_feature ?? '') == 1 ? 'selected' : '' }}>Yes
                            </option>
                            <option value="0" {{ old('is_feature', $video->is_feature ?? '') == 0 ? 'selected' : '' }}>No
                            </option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="status">Status</label>
                        <select name="status" id="status" class="form-select">
                            <option value="Active" {{ old('status', $video->status ?? '') == 'Active' ? 'selected' : '' }}>
                                Active</option>
                            <option value="Inactive" {{ old('status', $video->status ?? '') == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-primary">{{ isset($video) ? 'Update' : 'Submit' }}</button>
                    <a href="{{ route('admin.video') }}" class="btn btn-secondary">Back</a>
                </form>
            </div>
        </div>
    </div>

@endsection