@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Edit About Image</h3>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ route('web.about.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    {{-- Market Image --}}
                    <div class="form-group">
                        <label for="market_maestro_image">Market Maestro Image (610x691 px)</label>
                        <input type="file" name="market_maestro_image" id="market_maestro_image" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'preview_market')">
                        @if($data->market_maestro_image)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/about/' . $data->market_maestro_image) }}" class="img-fluid"
                                    style="max-height: 200px;">
                            </p>
                        @endif
                        <img id="preview_market" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>

                    {{-- Foundation Image 1 --}}
                    <div class="form-group">
                        <label for="foundation_image1">Foundation Image 1 (610x691 px)</label>
                        <input type="file" name="foundation_image1" id="foundation_image1" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'preview_foundation_1')">
                        @if($data->foundation_image1)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/about/' . $data->foundation_image1) }}" class="img-fluid"
                                    style="max-height: 150px;">
                            </p>
                        @endif
                        <img id="preview_foundation_1" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                    </div>

                    {{-- Foundation Image 2 --}}
                    <div class="form-group">
                        <label for="foundation_image2">Foundation Image 2 (610x691 px)</label>
                        <input type="file" name="foundation_image2" id="foundation_image2" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'preview_foundation_2')">
                        @if($data->foundation_image2)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/about/' . $data->foundation_image2) }}" class="img-fluid"
                                    style="max-height: 150px;">
                            </p>
                        @endif
                        <img id="preview_foundation_2" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                    </div>

                    {{-- Foundation Image 3 --}}
                    <div class="form-group">
                        <label for="foundation_image3">Foundation Image 3 (610x691 px)</label>
                        <input type="file" name="foundation_image3" id="foundation_image3" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'preview_foundation_3')">
                        @if($data->foundation_image3)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/about/' . $data->foundation_image3) }}" class="img-fluid"
                                    style="max-height: 150px;">
                            </p>
                        @endif
                        <img id="preview_foundation_3" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                    </div>

                    {{-- Founder Image 1 --}}
                    <div class="form-group">
                        <label for="founder_image1">Founder Image 1 (610x691 px)</label>
                        <input type="file" name="founder_image1" id="founder_image1" class="form-control" accept="image/*"
                            onchange="previewImage(this, 'preview_founder_1')">
                        @if($data->founder_image1)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/about/' . $data->founder_image1) }}" class="img-fluid"
                                    style="max-height: 150px;">
                            </p>
                        @endif
                        <img id="preview_founder_1" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                    </div>

                    {{-- Founder Image 2 --}}
                    <div class="form-group">
                        <label for="founder_image2">Founder Image 2 (610x691 px)</label>
                        <input type="file" name="founder_image2" id="founder_image2" class="form-control" accept="image/*"
                            onchange="previewImage(this, 'preview_founder_2')">
                        @if($data->founder_image2)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/about/' . $data->founder_image2) }}" class="img-fluid"
                                    style="max-height: 150px;">
                            </p>
                        @endif
                        <img id="preview_founder_2" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                    </div>

                    <button type="submit" class="btn btn-primary">Upload Images</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

@endsection