@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Edit Contact Image Upload</h3>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ route('web.contact.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    {{-- Contact Image --}}
                    <div class="form-group">
                        <label for="contact_image">Contact Image (672x726 px)</label>
                        <input type="file" name="contact_image" id="contact_image" class="form-control" accept="image/*"
                            onchange="previewImage(this, 'preview_contact')">
                        <small class="text-muted">Recommended size: 672x726 px</small>

                        {{-- Show current image --}}
                        @if(!empty($contact->contact_image))
                            <div class="mt-2">
                                <label>Current Image:</label><br>
                                <img src="{{ asset('uploads/contact/' . $contact->contact_image) }}" class="img-fluid"
                                    style="max-height: 200px;">
                            </div>
                        @endif

                        {{-- Preview new image --}}
                        <img id="preview_contact" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>

                    <button type="submit" class="btn btn-primary">Update Image</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

@endsection