@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Donation Image Upload</h3>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ route('web.donation.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    {{-- Donation Image --}}
                    <div class="form-group">
                        <label for="donation_image">Donation Image (2256x3384 px)</label>
                        <input type="file" name="donation_image" id="donation_image" class="form-control" accept="image/*"
                            onchange="previewImage(this, 'preview_donation')">
                        <small class="text-muted">Recommended size: 2256x3384 px</small>
                        <img id="preview_donation" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>



                    <button type="submit" class="btn btn-primary">Upload Images</button>
                </form>
            </div>
        </div>
    </div>


    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

@endsection