@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Edit Home Images</h3>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ route('webhome.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    {{-- Banner Image --}}
                    <div class="form-group">
                        <label for="banner_image">Banner Image (1920x803 px)</label>
                        <input type="file" name="banner_image" id="banner_image" class="form-control" accept="image/*"
                            onchange="previewImage(this, 'preview_banner')">
                        <small class="text-muted">Recommended size: 1920x803 px</small>
                        @if($webhome && $webhome->banner_image)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/home/' . $webhome->banner_image) }}" class="img-fluid"
                                    style="max-height: 200px;">
                            </p>
                        @endif
                        <img id="preview_banner" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>

                    <div class="form-group">
                        <label for="about_image1">About Image 1 (305x418 px)</label>
                        <input type="file" name="about_image1" id="about_image1" class="form-control" accept="image/*"
                            onchange="previewImage(this, 'preview_about1')">
                        @if($webhome && $webhome->about_image1)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/home/' . $webhome->about_image1) }}" class="img-fluid"
                                    style="max-height: 200px;">
                            </p>
                        @endif
                        <img id="preview_about1" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>

                    <div class="form-group">
                        <label for="about_image2">About Image 2 (305x292 px)</label>
                        <input type="file" name="about_image2" id="about_image2" class="form-control" accept="image/*"
                            onchange="previewImage(this, 'preview_about2')">
                        @if($webhome && $webhome->about_image2)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/home/' . $webhome->about_image2) }}" class="img-fluid"
                                    style="max-height: 200px;">
                            </p>
                        @endif
                        <img id="preview_about2" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>

                    <div class="form-group">
                        <label for="about_image3">About Image 3 (305x229 px)</label>
                        <input type="file" name="about_image3" id="about_image3" class="form-control" accept="image/*"
                            onchange="previewImage(this, 'preview_about3')">
                        @if($webhome && $webhome->about_image3)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/home/' . $webhome->about_image3) }}" class="img-fluid"
                                    style="max-height: 200px;">
                            </p>
                        @endif
                        <img id="preview_about3" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>



                    {{-- Campaign Images --}}
                    <div class="form-group">
                        <label>Campaign Images (Each: 266x242 px)</label>

                        @for ($i = 1; $i <= 4; $i++)
                            <div class="mb-2">
                                <label for="campaign_image{{ $i }}">Campaign Image {{ $i }}</label>
                                <input type="file" name="campaign_image{{ $i }}" id="campaign_image{{ $i }}"
                                    class="form-control" accept="image/*"
                                    onchange="previewImage(this, 'preview_campaign_{{ $i }}')">
                                @php $key = 'campaign_image' . $i; @endphp
                                @if($webhome && $webhome->$key)
                                    <p class="mt-2">Current:
                                        <img src="{{ asset('uploads/home/' . $webhome->$key) }}" class="img-fluid"
                                            style="max-height: 150px;">
                                    </p>
                                @endif
                                <img id="preview_campaign_{{ $i }}" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                            </div>
                        @endfor
                    </div>

                    {{-- Community Impact Image --}}
                    <div class="form-group">
                        <label for="community_impact_image">Community Impact Image (652x587 px)</label>
                        <input type="file" name="community_impact_image" id="community_impact_image" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'preview_community')">
                        @if($webhome && $webhome->community_impact_image)
                            <p class="mt-2">Current:
                                <img src="{{ asset('uploads/home/' . $webhome->community_impact_image) }}" class="img-fluid"
                                    style="max-height: 200px;">
                            </p>
                        @endif
                        <img id="preview_community" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>

                    {{-- Volunteer Images --}}
                    @for ($i = 1; $i <= 2; $i++)
                        <div class="form-group">
                            <label for="volunteer_image{{ $i }}">Volunteer Image {{ $i }}</label>
                            <input type="file" name="volunteer_image{{ $i }}" id="volunteer_image{{ $i }}" class="form-control"
                                accept="image/*" onchange="previewImage(this, 'preview_volunteer{{ $i }}')">
                            @php $key = 'volunteer_image' . $i; @endphp
                            @if($webhome && $webhome->$key)
                                <p class="mt-2">Current:
                                    <img src="{{ asset('uploads/home/' . $webhome->$key) }}" class="img-fluid"
                                        style="max-height: 200px;">
                                </p>
                            @endif
                            <img id="preview_volunteer{{ $i }}" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                        </div>
                    @endfor

                    <button type="submit" class="btn btn-success">Update Images</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

@endsection