@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Website Images</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Website Images</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body webimage-static-table">
                <h4 class="card-title mb-4">Website Image Management</h4>
                @if(Session::has('status'))
                    <p class="alert alert-success">{{ Session::get('status') }}</p>
                @endif
                <table class="table table-bordered table-striped">
                    <thead class="table-dark">
                        <tr>
                            <th>Pages</th>
                            <th style="width: 200px;">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Home</td>
                            <td>


                                <a href="{{ route('webhome.edit') }}" class="btn btn-success btn-sm">
                                    <i class="mdi mdi-image-edit"></i>
                                    Edit Image
                                </a>


                            </td>
                        </tr>
                        <tr>
                            <td>About Us</td>
                            <td>

                                <a href="{{ route('web.about.edit') }}" class="btn btn-success btn-sm">
                                    <i class="mdi mdi-image-edit"></i>
                                    Edit Image
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td>Project</td>
                            <td>

                                <a href="{{ route('web-project.edit') }}" class="btn btn-success btn-sm">
                                    <i class="mdi mdi-image-edit"></i>
                                    Edit Image
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td>Contact Us</td>
                            <td>

                                <a href="{{ route('web.contact.edit') }}" class="btn btn-success btn-sm">
                                    <i class="mdi mdi-image-edit"></i>
                                    Edit Image
                                </a>
                            </td>
                        </tr>
                        <tr>
                            <td>Donation</td>
                            <td>

                                <a href="{{ route('web.donation.edit') }}" class="btn btn-success btn-sm">
                                    <i class="mdi mdi-image-edit"></i>
                                    Edit Image
                                </a>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection