@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Edit Project Images</h3>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ route('web.project.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    {{-- Repeat for all 6 images --}}
                    @for ($i = 1; $i <= 6; $i++)
                        <div class="form-group">
                            <label for="project_image{{ $i }}">Project Image {{ $i }} (376x242 px)</label>
                            <input type="file" name="project_image{{ $i }}" id="project_image{{ $i }}" class="form-control"
                                accept="image/*" onchange="previewImage(this, 'preview_project_{{ $i }}')">

                            @php
                                $imageField = 'project_image' . $i;
                            @endphp

                            @if(!empty($data->$imageField))
                                <p class="mt-2">Current:
                                    <img src="{{ asset('uploads/project/' . $data->$imageField) }}" class="img-fluid"
                                        style="max-height: 150px;">
                                </p>
                            @endif

                            <img id="preview_project_{{ $i }}" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                        </div>
                    @endfor

                    <button type="submit" class="btn btn-primary">Update Images</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

@endsection