@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Web Settings</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('websettings') }}">Web Settings</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Add Web Settings</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="{{ route('websettings.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                        <label for="exampleInputName1">Company Name</label>
                        <input type="text" class="form-control" id="exampleInputName1" placeholder="Enter Company Name"
                            name="company_name" value="{{ old('company_name') }}">
                        @error('company_name')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="exampleInputName1">Company Email</label>
                        <input type="email" class="form-control" id="exampleInputName1" placeholder="Enter Company Email"
                            name="company_email" value="{{ old('company_email') }}">
                        @error('company_email')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="exampleInputName1">Company Phone</label>
                        <input type="text" class="form-control" id="exampleInputName1" placeholder="Enter Company Phone"
                            name="company_phone" value="{{ old('company_phone') }}">
                        @error('company_phone')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="exampleInputName1">Company Address</label>
                        <textarea class="form-control" id="exampleInputName1" placeholder="Enter Company Address"
                            name="company_address" value="{{ old('company_address') }}"></textarea>
                        @error('company_address')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    {{-- Certificate Image --}}
                    <div class="form-group">
                        <label for="websettings_image"> Logo </label>
                        <input type="file" name="websettings_image" id="websettings_image" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'websettings_certificate')">
                        <small class="text-muted">Recommended size: 500x500 px</small>
                        <img id="websettings_certificate" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>
                    {{-- status --}}
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="Active">Active</option>
                            <option value="Inactive">Inactive</option>
                        </select>
                    </div>



                    <button type="submit" class="btn btn-primary">Add Web Settings</button>
                </form>
            </div>
        </div>
    </div>


    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

@endsection