@extends('layouts.admin')
@section('content')

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Web Settings</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('websettings') }}">Web Settings</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Add Web Settings</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <form class="forms-sample" action="{{ route('websettings.update', $websettings->_id) }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="form-group">
                        <label for="exampleInputName1">Company Name</label>
                        <input type="text" class="form-control" id="exampleInputName1" placeholder="Enter Company Name"
                            name="company_name" value="{{ old('company_name', $websettings->company_name) }}">
                        @error('company_name')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="exampleInputName1">Company Email</label>
                        <input type="email" class="form-control" id="exampleInputName1" placeholder="Enter Company Email"
                            name="company_email" value="{{ old('company_email', $websettings->company_email) }}">
                        @error('company_email')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="exampleInputName1">Company Phone</label>
                        <input type="text" class="form-control" id="exampleInputName1" placeholder="Enter Company Phone"
                            name="company_phone" value="{{ old('company_phone', $websettings->company_phone) }}">
                        @error('company_phone')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label for="exampleInputName1">Company Address</label>
                        <textarea class="form-control" id="company_address" name="company_address"
                            vlaue="{{ old('company_address') }}">{{ old('company_address', $websettings->company_address) }}</textarea>
                        @error('company_address')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    {{-- Certificate Image --}}
                    <div class="form-group">
                        <label for="websettings_image"> Logo </label>
                        <input type="file" name="websettings_image" id="websettings_image" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'websettings_certificate')">
                        <small class="text-muted">Recommended size: 500x500 px</small>
                        <br>
                        <img src="{{ asset('uploads/websettings/' . $websettings->websettings_image) }}"
                            id="websettings_certificate" class="img-fluid mt-2" style="max-height: 200px;">
                    </div>

                    <!-- Facebook Link -->
                    <div class="form-group">
                        <label for="facebook_link">Facebook Link</label>
                        <input type="url" class="form-control" id="facebook_link" placeholder="Enter Facebook URL"
                            name="facebook_link" value="{{ old('facebook_link', $websettings->facebook_link) }}">
                        @error('facebook_link')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Instagram Link -->
                    <div class="form-group">
                        <label for="insta_link">Instagram Link</label>
                        <input type="url" class="form-control" id="insta_link" placeholder="Enter Instagram URL"
                            name="insta_link" value="{{ old('insta_link', $websettings->insta_link) }}">
                        @error('insta_link')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- Twitter Link -->
                    <div class="form-group">
                        <label for="twitter_link">Twitter Link</label>
                        <input type="url" class="form-control" id="twitter_link" placeholder="Enter Twitter URL"
                            name="twitter_link" value="{{ old('twitter_link', $websettings->twitter_link) }}">
                        @error('twitter_link')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- LinkedIn Link -->
                    <div class="form-group">
                        <label for="linkdin_link">LinkedIn Link</label>
                        <input type="url" class="form-control" id="linkdin_link" placeholder="Enter LinkedIn URL"
                            name="linkdin_link" value="{{ old('linkdin_link', $websettings->linkdin_link) }}">
                        @error('linkdin_link')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    {{-- status --}}
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="Active" {{ $websettings->is_feature == 'Active' ? 'selected' : '' }}>Active
                            </option>
                            <option value="Inactive" {{ $websettings->is_feature == 'Inactive' ? 'selected' : '' }}>Inactive
                            </option>
                        </select>
                    </div>



                    <button type="submit" class="btn btn-primary">Update Web Settings</button>
                </form>
            </div>
        </div>
    </div>


    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

@endsection