@extends('layouts.attach')
@section('content')


    <!-- page banner start -->
    <div class="page-banner-area bgs-cover overlay text-white py-165 rpy-125 rmt-65"
        style="background-image: url({{asset('assets/front/img/background/page-banner.jpg')}});">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-12">
                    <div class="breadcrumb-inner text-center">
                        <h2 class="page-title">{{ $blog->title }}</h2>
                        <ul class="page-list">
                            <li><a href="{{route('home')}}">Home</a></li>
                            <li>Blog Details</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- page banner end -->


    <!-- Blog Details area start -->
    <div class="blog-details-area py-120">
        <div class="container">
            <div class="row gap-60">
                <div class="col-lg-8">
                    <div class="blog-details-content mb-55">
                        <div class="details-image rel mb-35">
                            <img src="{{ asset('uploads/blog/' . $blog->image) }}" alt="Blog Clasic">
                            <div class="post-date">
                                <b>{{ \Carbon\Carbon::parse($blog->created_at)->format('d') }}</b>
                                <span>{{ \Carbon\Carbon::parse($blog->created_at)->format('M') }}</span>
                            </div>
                        </div>
                        <ul class="blog-meta">
                            <li><i class="flaticon-user"></i> <a
                                    href="#">{{ $blog->authorDetail->name ?? 'unknown author' }}</a></li>
                        </ul>
                        <p>{!! preg_replace('/<\?xml.*?\?>/', '', $blog->description) !!}</p>
                        <hr>
                        <div class="tag-and-share">
                            <div class="row align-items-center">
                                <div class="col-md-7">
                                    <div class="tags">
                                        <strong>Tag : </strong>
                                        <a href="#">{{ $blog->tag }}</a>
                                    </div>
                                </div>
                                <div class="col-md-5 text-md-end">
                                    <div class="share-area">
                                        <strong>Share: </strong>
                                        <div class="social-share">
                                            <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}"
                                                target="_blank" title="Share on Facebook">
                                                <i class="fab fa-facebook-f"></i>
                                            </a>

                                            <a href="https://twitter.com/intent/tweet?url={{ urlencode(url()->current()) }}&text={{ urlencode($blog->title) }}"
                                                target="_blank" title="Share on Twitter">
                                                <i class="fab fa-twitter"></i>
                                            </a>

                                            <a href="https://www.pinterest.com/pin/create/button/?url={{ urlencode(url()->current()) }}&media={{ urlencode(asset('uploads/blog/' . $blog->image)) }}&description={{ urlencode($blog->title) }}"
                                                target="_blank" title="Share on Pinterest">
                                                <i class="fab fa-pinterest-p"></i>
                                            </a>

                                            <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ urlencode(url()->current()) }}&title={{ urlencode($blog->title) }}"
                                                target="_blank" title="Share on LinkedIn">
                                                <i class="fab fa-linkedin-in"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                    </div>




                </div>


                <div class="col-lg-4">
                    <div class="main-sidebar rmt-75">

                        <div class="widget widget_catagory">
                            <h5 class="widget-title">Our Categories</h5>
                            <ul class="catagory-items">
                                @foreach ($category as $item)
                                    <li><a href="#">{{ $item->name }}</a></li>
                                @endforeach
                            </ul>
                        </div>


                        <div class="widget widget-recent-post">
                            <h4 class="widget-title">Recent News</h4>
                            <ul>



                                <li>
                                    <div class="media">
                                        <div class="media-left">
                                            <img src="{{ asset('uploads/blog/' . $blog->image) }}" alt="{{ $blog->title }}">
                                        </div>
                                        <div class="media-body">
                                            <h6 class="title"><a
                                                    href="{{ url('/blog/' . $blog->slug) }}">{{ $blog->title }}</a></h6>
                                            <ul class="post-info">

                                                <li><i class="fas fa-user"></i> <a
                                                        href="#">{{ $blog->authorDetail->name ?? 'Unknown Author' }}</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </li>



                            </ul>
                        </div>

                        <div class="widget widget_cta">
                            <div class="cta-widget-inner" style="background-image: url(assets/img/widgets/cta-bg.jpg);">
                                <h5>We have provided financial help to 5 million people</h5>
                                <a class="btn ml-5" href="{{ route('about.donate') }}">Donate Now</a>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
    <!-- Blog Details area end -->


@endsection