@extends('layouts.attach')
@section('content')


    <!-- page banner start -->
    <div class="page-banner-area bgs-cover overlay text-white py-165 rpy-125 rmt-65"
        style="background-image: url({{asset('assets/front/img/background/page-banner.jpg')}});">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-7 col-lg-8">
                    <div class="breadcrumb-inner text-center">
                        <h2 class="page-title">Blog </h2>
                        <ul class="page-list">
                            <li><a href="{{route('home')}}">Home</a></li>
                            <li>Blog </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- page banner end -->


    <!-- Blog Clasic area start -->
    <div class="blog-clasic-area py-120">
        <div class="container">
            <div class="row gap-60">
                <div class="col-lg-8">

                    @foreach ($blogs as $item)
                        <div class="blog-item blog-item--clasic">
                            <div class="blog-item__img">
                                <img src="{{ asset('uploads/blog/' . $item->image) }}" alt="{{ $item->title }}">
                                <div class="post-date">
                                    <b>{{ \Carbon\Carbon::parse($item->created_at)->format('d') }}</b>
                                    <span>{{ \Carbon\Carbon::parse($item->created_at)->format('M') }}</span>
                                </div>
                            </div>
                            <div class="blog-item__content">
                                <ul class="blog-meta">
                                    <li><i class="flaticon-user"></i> <a
                                            href="#">{{ $item->authorDetail->name ?? 'Unknown Author' }}</a></li>

                                </ul>
                                <h4><a href="{{ url('/blog/' . $item->slug) }}">{{ $item->title }}</a></h4>
                                <p>{{ \Illuminate\Support\Str::words(strip_tags(html_entity_decode($item->description)), 25, '...') }}
                                </p>
                                <a href="{{ url('/blog/' . $item->slug) }}" class="read-more">Read More</a>
                            </div>
                        </div>

                    @endforeach


                </div>
                <div class="col-lg-4">
                    <div class="main-sidebar rmt-75">

                        <div class="widget widget_catagory">
                            <h5 class="widget-title">Our Categories</h5>
                            <ul class="catagory-items">
                                @foreach ($category as $item)
                                    <li><a href="#">{{ $item->name }}</a></li>
                                @endforeach
                            </ul>
                        </div>


                        <div class="widget widget-recent-post">
                            <h4 class="widget-title">Recent News</h4>
                            <ul>

                                @foreach ($blogs as $item)

                                    <li>
                                        <div class="media">
                                            <div class="media-left">
                                                <img src="{{ asset('uploads/blog/' . $item->image) }}" alt="{{ $item->title }}">
                                            </div>
                                            <div class="media-body">
                                                <h6 class="title"><a
                                                        href="{{ url('/blog/' . $item->slug) }}">{{ $item->title }}</a></h6>
                                                <ul class="post-info">

                                                    <li><i class="fas fa-user"></i> <a
                                                            href="#">{{ $item->authorDetail->name ?? 'Unknown Author' }}</a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </li>

                                @endforeach

                            </ul>
                        </div>

                        <div class="widget widget_cta">
                            <div class="cta-widget-inner" style="background-image: url(assets/img/widgets/cta-bg.jpg);">
                                <h5>We have provided financial help to 5 million people</h5>
                                <a class="btn ml-5" href="{{ route('about.donate') }}">Donate Now</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Blog Clasic area end -->


@endsection