@extends('layouts.attach')
@section('content')


    <!-- page banner start -->
    <div class="page-banner-area bgs-cover overlay text-white py-165 rpy-125 rmt-65"
        style="background-image: url({{asset('assets/front/img/background/page-banner.jpg')}});">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-7 col-lg-8">
                    <div class="breadcrumb-inner text-center">
                        <h2 class="page-title">Contact Us</h2>
                        <ul class="page-list">
                            <li><a href="{{route('home')}}">Home</a></li>
                            <li>Contact Us</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- page banner end -->



    @foreach ($webData as $item)
        <!-- Contact Info area start -->
        <div class="contact-info-area py-65 ">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-4 col-sm-6">
                        <div class="contact-info-item contact-info-item--green">
                            <div class="contact-info__icon"><i class="fa fa-phone"></i></div>
                            <h5>Phone Number</h5>
                            <div class="contact-info__text">
                                <a href="callto:{{ $item->company_phone }}">{{ $item->company_phone }}</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6">
                        <div class="contact-info-item contact-info-item--yellow">
                            <div class="contact-info__icon"><i class="fas fa-paper-plane"></i></div>
                            <h5>Email Address</h5>
                            <div class="contact-info__text">
                                <a href="mailto:{{ $item->company_email }}">{{ $item->company_email }}</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 col-sm-6">
                        <div class="contact-info-item">
                            <div class="contact-info__icon"><i class="flaticon-pin"></i></div>
                            <h5>Offce address</h5>
                            <div class="contact-info__text">
                                2{{ $item->company_address }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Contact Info area end -->
    @endforeach


    <!-- Contact page area start -->
    <div class="contact-page-area overflow-hidden  rpt-100">
        <div class="container-xl ">
            <div class="row gap-60 align-items-center pt-5 ">
                <div class="col-lg-6">
                    <div class="faq-three-left-part mb-20 rel rmb-75">
                        @foreach ($contactData as $item)
                            <img src="{{ asset('uploads/contact/' . $item->contact_image) }}" alt="Man">
                        @endforeach

                    </div>
                </div>
                <div class="col-lg-6 ">
                    <div class=" form-style-two  py-110 rpy-85 contact-form-card contact-form-bg">
                        <div class="section-title mb-10">
                            <span class="section-title__subtitle mb-10">Need help</span>
                            <h3>Get In touch</h3>
                        </div>
                        <form id="contactForm" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-xl-9 mb-10">
                                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
                                        incididunt</p>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="name">Your Name</label>
                                        <input type="text" id="name" name="name" class="form-control" value=""
                                            placeholder="Enter Your Name" required>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="phone">Phone Number</label>
                                        <input type="text" id="phone" name="phone" class="form-control" value=""
                                            placeholder="Phone Number">
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="email">Your Email</label>
                                        <input type="email" id="email" name="email" class="form-control" value=""
                                            placeholder="Enter Email Address" required>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="message">Message</label>
                                        <textarea name="message" id="message" class="form-control" rows="2"
                                            placeholder="Write Your Messages" required></textarea>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group pt-10 mb-0">
                                        <button type="submit" class="btn ml-5">Submit</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Contact page area end -->




    <!-- Location Map Area Start -->

    <!-- Location Map Area End -->
    @push('scripts')
        <script>
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            let hasSubmittedBefore = false; // flag to track first submission

            $('#contactForm').on('submit', function (e) {
                e.preventDefault();

                let formData = new FormData(this);

                $.ajax({
                    url: "{{ route('contact.store') }}",
                    method: "POST",
                    data: formData,
                    processData: false,
                    contentType: false,
                    success: function (res) {
                        let successMessage = hasSubmittedBefore
                            ? 'Thank you, we’ve already received your message. We will be in touch soon.'
                            : 'We will contact you soon.';

                        Swal.fire({
                            icon: 'success',
                            title: 'Message Sent!',
                            text: successMessage,
                            confirmButtonColor: '#f84d42',
                            confirmButtonText: 'OK'
                        }).then(() => {
                            $('#contactForm')[0].reset();
                        });

                        hasSubmittedBefore = true;
                    },
                    error: function (xhr) {
                        let response = xhr.responseJSON;
                        let message = 'Something went wrong.';

                        if (response && response.errors) {
                            message = Object.values(response.errors).map(errorArr => errorArr[0]).join('\n');
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Validation Error',
                            text: message,
                            confirmButtonColor: '#d33',
                        });
                    }
                });
            });
        </script>



    @endpush

@endsection