<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Market Maestro: Ankit Yadav</title>
    <!-- plugins:css -->
    <link rel="stylesheet" href="{{asset('assets/vendors/mdi/css/materialdesignicons.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/vendors/ti-icons/css/themify-icons.css')}}">
    <link rel="stylesheet" href="{{asset('assets/vendors/css/vendor.bundle.base.css')}}">
    <link rel="stylesheet" href="{{asset('assets/vendors/font-awesome/css/font-awesome.min.css')}}">
    <!-- endinject -->
    <!-- Plugin css for this page -->
    <link rel="stylesheet" href="{{asset('assets/vendors/font-awesome/css/font-awesome.min.css')}}" />
    <link rel="stylesheet" href="{{asset('assets/vendors/bootstrap-datepicker/bootstrap-datepicker.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/summernote/summernote-bs4.css')}}">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css">
    <!-- End plugin css for this page -->
    <link rel="stylesheet" href="{{asset('assets/css/style.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/sweetalert2.css')}}">
    <!-- End layout styles -->
    <link rel="shortcut icon" href="{{asset('assets/images/favicon.png')}}" />

</head>

<body>
    <div class="container-scroller">

        <!-- partial:partials/_navbar.html -->
        <nav class="navbar default-layout-navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
            <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-start">
                <a class="navbar-brand brand-logo" href="{{ route('dashboard') }}"><img
                        src="{{ asset('assets/images/logo.png') }}" alt="logo" /></a>
                <a class="navbar-brand brand-logo-mini" href="index.html"><img
                        src="{{ asset('assets/images/logo-mini.svg') }}" alt="logo" /></a>
            </div>
            <div class="navbar-menu-wrapper d-flex align-items-stretch">
                <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
                    <span class="mdi mdi-menu"></span>
                </button>
                <ul class="navbar-nav navbar-nav-right">
                    <li class="nav-item nav-profile dropdown">
                        <a class="nav-link dropdown-toggle" id="profileDropdown" href="#" data-bs-toggle="dropdown"
                            aria-expanded="false">
                            <div class="nav-profile-img">
                                <img src="{{ asset('assets/images/faces/admin.png') }}" alt="image">
                                <span class="availability-status online"></span>
                            </div>
                            <div class="nav-profile-text">
                                <p class="mb-1 text-black">{{ ucfirst(auth()->user()->name)}}</p>
                            </div>
                        </a>
                        <div class="dropdown-menu navbar-dropdown" aria-labelledby="profileDropdown">
                            <a class="dropdown-item" href="{{ route('profile.edit') }}">
                                <i class="mdi mdi-cached me-2 text-success"></i> Profile
                            </a>
                            <div class="dropdown-divider"></div>

                            <!-- Logout Form -->
                            <form method="POST" action="{{ route('logout') }}" class="p-0 m-0">
                                @csrf
                                <button type="submit" class="dropdown-item btn btn-link py-2 m-0">
                                    <i class="mdi mdi-logout me-2 text-primary"></i> Signout
                                </button>
                            </form>
                        </div>

                    </li>
                    <li class="nav-item d-none d-lg-block full-screen-link">
                        <a class="nav-link">
                            <i class="mdi mdi-fullscreen" id="fullscreen-button"></i>
                        </a>
                    </li>



                </ul>
                <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button"
                    data-toggle="offcanvas">
                    <span class="mdi mdi-menu"></span>
                </button>
            </div>
        </nav>
        <!-- partial -->
        <div class="container-fluid page-body-wrapper">
            <!-- partial:partials/_sidebar.html -->
            <nav class="sidebar sidebar-offcanvas" id="sidebar">
                <ul class="nav">
                    <li class="nav-item nav-profile">
                        <a href="#" class="nav-link">
                            <div class="nav-profile-image">
                                <img src="{{ asset('assets/images/faces/admin.png') }}" alt="profile" />
                                <span class="login-status online"></span>
                                <!--change to offline or busy as needed-->
                            </div>
                            <div class="nav-profile-text d-flex flex-column">
                                <span class="font-weight-bold mb-2">{{ auth()->user()->name }}</span>

                            </div>
                            <i class="mdi mdi-bookmark-check text-success nav-profile-badge"></i>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="{{ route('dashboard') }}">
                            <span class="menu-title">Dashboard</span>
                            <i class="mdi mdi-home menu-icon"></i>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link collapsed" data-bs-toggle="collapse" href="#layouts" aria-expanded="false"
                            aria-controls="layouts">
                            <span class="menu-title">Post</span>
                            <i class="menu-arrow"></i>
                            <i class="mdi mdi-note-text menu-icon"></i>
                        </a>
                        <div class="collapse" id="layouts" style="">
                            <ul class="nav flex-column sub-menu">
                                <li class="nav-item">
                                    <a href="{{ route('blog') }}"
                                        class="nav-link {{ request()->routeIs('blog') ? 'active' : '' }}"> Blog List
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ request()->routeIs('category') || request()->routeIs('category') ? 'active' : '' }}"
                                        href="{{ route('category') }}"> Category </a>
                                </li>
                            </ul>
                        </div>
                    </li>



                    <li class="nav-item">
                        <a class="nav-link collapsed" data-bs-toggle="collapse" href="#weblayouts" aria-expanded="false"
                            aria-controls="layouts">
                            <span class="menu-title">Settings</span>
                            <i class="menu-arrow"></i>
                            <i class="mdi mdi mdi-wrench menu-icon"></i>
                        </a>
                        <div class="collapse" id="weblayouts" style="">
                            <ul class="nav flex-column sub-menu">
                                <li class="nav-item">
                                    <a href="{{ route('websettings') }}"
                                        class="nav-link {{ request()->routeIs('websettings') ? 'active' : '' }}">
                                        Website Settings </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ request()->routeIs('webimage') ? 'active' : '' }}"
                                        href="{{ route('webimage') }}"> Website Images </a>
                                </li>
                            </ul>
                        </div>
                    </li>




                    <li class="nav-item">
                        <a class="nav-link active" href="{{ route('certificate') }}">
                            <span class="menu-title">Certificate</span>
                            <i class="mdi mdi-certificate menu-icon"></i>
                        </a>
                    </li>


                    <li class="nav-item">
                        <a class="nav-link active" href="{{ route('users') }}">
                            <span class="menu-title">All Customers</span>
                            <i class="mdi mdi-account-group menu-icon"></i>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="{{ route('admin.contact.message.view') }}">
                            <span class="menu-title">Customer Inquiries</span>
                            <i class="mdi mdi-card-account-details-outline menu-icon"></i>
                        </a>
                    </li>



                </ul>
            </nav>



            <div class="content-wrapper">
                <div class="page-header">
                    <h3 class="page-title"> Profile </h3>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Profile</li>
                        </ol>
                    </nav>
                </div>

                <div class="card">
                    <div class="card-body">
                        <h1 class="card-title mb-4">Edit</h1>

                        <form id="send-verification" method="post" action="{{ route('verification.send') }}">
                            @csrf
                        </form>
                        <form method="post" action="{{ route('profile.update') }}" class="mt-6 space-y-6">
                            @csrf
                            @method('patch')

                            @if (session('status') === 'profile-updated')
                                <p class="alert alert-success">Profile updated successfully.</p>
                            @endif

                            <div>
                                <x-input-label for="name" :value="__('Name')" />
                                <x-text-input class="form-control mt-2" id="name" name="name" type="text"
                                    :value="old('name', $user->name)" required autofocus autocomplete="name" />
                                <x-input-error class="mt-2" :messages="$errors->get('name')" />
                            </div>

                            <div class="mt-3">
                                <x-input-label for="email" :value="__('Email')" />
                                <x-text-input id="email" name="email" type="email" class="form-control mt-2"
                                    :value="old('email', $user->email)" required autocomplete="username" />
                                <x-input-error class="mt-2" :messages="$errors->get('email')" />

                                @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && !$user->hasVerifiedEmail())
                                    <div>
                                        <p class="text-sm mt-2 text-gray-800">
                                            {{ __('Your email address is unverified.') }}

                                            <button form="send-verification"
                                                class="underline text-sm text-gray-600 hover:text-gray-900 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                                {{ __('Click here to re-send the verification email.') }}
                                            </button>
                                        </p>

                                        @if (session('status') === 'verification-link-sent')
                                            <p class="mt-2 font-medium text-sm text-green-600">
                                                {{ __('A new verification link has been sent to your email address.') }}
                                            </p>
                                        @endif
                                    </div>
                                @endif
                            </div>

                            <div class="flex items-center gap-4 mt-3">
                                <button type="submit" class="btn btn-gradient-primary me-2">{{ __('Update') }}</button>
                                <a href="{{ route('dashboard') }}" class="btn btn-light">Cancel</a>


                            </div>
                        </form>



                    </div>
                </div>