<?php

use App\Http\Controllers\admin\BlogController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use MongoDB\Client;
//front_controllers
use App\Http\Controllers\front\HomeController;
use App\Http\Controllers\front\AboutController;
use App\Http\Controllers\front\ProjectController;
use App\Http\Controllers\front\BlogsController;
use App\Http\Controllers\front\ContactController;
use App\Http\Controllers\front\DonateController;

// Route::get('/', function () {
//      return view('welcome');
//  });
Route::get('/', [HomeController::class, 'home'])->name('home');
Route::get('/home', [HomeController::class, 'home'])->name('home');

//About Page
Route::get('/about-founder', [AboutController::class, 'home'])->name('about.founder');
Route::get('/about-foundation', [AboutController::class, 'foundation'])->name('about.foundation');
Route::get('/market-maestro', [AboutController::class, 'market'])->name('about.market');

//Project Page
Route::get('/our-projects', [ProjectController::class, 'home'])->name('about.project');

//Blog Page
Route::get('/our-blogs', [BlogsController::class, 'home'])->name('about.blogs');
Route::get('/blog/{slug}', [BlogsController::class, 'show'])->name('blog.show');

//Contact Page
Route::get('/contact-us', [ContactController::class, 'home'])->name('about.contact');
Route::post('/contact', [ContactController::class, 'contactMessageStore'])->name('contact.store');

//Donation Page
Route::get('/donate-us', [DonateController::class, 'home'])->name('about.donate');


Route::get('/dashboard', function () {
    return view('dashboard');

})->middleware(['auth', 'verified'])->name('dashboard');


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    //category route
    Route::get('/category', [BlogController::class, 'category'])->name('category');
    Route::get('/admin/category/create', [BlogController::class, 'categoryCreate'])->name('category.create');
    Route::post('/admin/category/store', [BlogController::class, 'categoryStore'])->name('category.store');
    Route::get('/admin/category/edit/{id}', [BlogController::class, 'categoryEdit'])->name('category.edit');
    Route::get('/admin/category/data', [BlogController::class, 'getCategoryData'])->name('admin.category.data');
    Route::put('/admin/category/update/{id}', [BlogController::class, 'categoryUpdate'])->name('category.update');
    Route::delete('/admin/category/delete/{id}', [BlogController::class, 'categoryDelete'])->name('category.delete');
    Route::post('/admin/category/update-status', [BlogController::class, 'categoryUpdateStatus'])->name('admin.category.updateStatus');
    //blog route
    Route::get('/admin/blog', [BlogController::class, 'blogs'])->name('blog');
    Route::get('/admin/blog/create', [BlogController::class, 'index'])->name('blog.create');
    Route::post('/admin/blog/store', [BlogController::class, 'store'])->name('blog.store');
    Route::post('/admin/blog/update-feature-status', [BlogController::class, 'updateFeatureStatus'])->name('admin.blog.updateFeatureStatus');
    Route::get('/admin/blogs/data', [BlogController::class, 'getBlogsData'])->name('admin.blogs.data');
    Route::delete('/admin/blog/delete/{id}', [BlogController::class, 'blogdestroy'])->name('blog.delete');
    Route::get('/admin/blog/edit/{id}', [BlogController::class, 'blogEdit'])->name('blog.edit');
    Route::put('/admin/blog/update/{id}', [BlogController::class, 'blogUpdate'])->name('blog.update');

    //web image route
    Route::get('/admin/webimage', [BlogController::class, 'webimage'])->name('webimage');
    Route::get('/admin/home/image', [BlogController::class, 'webhome'])->name('web.home');

    Route::post('/admin/home/store', [BlogController::class, 'homestore'])->name('web.home.store');
    Route::get('/admin/webhome/edit', [BlogController::class, 'webhomeEdit'])->name('webhome.edit');
    Route::post('/admin/webhome/update', [BlogController::class, 'webhomeUpdate'])->name('webhome.update');
    //web about image route
    Route::get('/admin/about/image', [BlogController::class, 'webabout'])->name('web.about');
    Route::post('/admin/about/image', [BlogController::class, 'webaboutstore'])->name('web.about.store');
    Route::get('/admin/about/edit/', [BlogController::class, 'webaboutedit'])->name('web.about.edit');
    Route::post('/admin/about/update/', [BlogController::class, 'webaboutupdate'])->name('web.about.update');
    //web-project
    Route::get('/admin/project/images', [BlogController::class, 'webproject'])->name('web.project.image');
    Route::get('/admin/project/edit', [BlogController::class, 'webprojectedit'])->name('web-project.edit');
    Route::post('/admin/project/images', [BlogController::class, 'webprojectstore'])->name('web-project.store');
    Route::post('/admin/project/update', [BlogController::class, 'webprojectupdate'])->name('web.project.update');

    //web Contact
    Route::get('/admin/contact/images', [BlogController::class, 'webcontact'])->name('web.contact');
    Route::get('/admin/contact/images/edit', [BlogController::class, 'webcontactedit'])->name('web.contact.edit');
    Route::post('/admin/contact/images', [BlogController::class, 'webcontactStore'])->name('web.contact.store');
    Route::post('/admin/contact/images/update', [BlogController::class, 'webcontactUpdate'])->name('web.contact.update');
    //web donation 
    Route::get('/admin/donation/images', [BlogController::class, 'webdonation'])->name('web.donation');
    Route::post('/admin/donation/images/store', [BlogController::class, 'webdonationstore'])->name('web.donation.store');
    Route::get('/admin/donation/images/edit', [BlogController::class, 'webdonationedit'])->name('web.donation.edit');
    Route::post('/admin/donation/images/update', [BlogController::class, 'webdonationupdate'])->name('web.donation.update');
    //certificate
    Route::get('/admin/certificate', [BlogController::class, 'certificate'])->name('certificate');
    Route::get('/admin/certificate/create', [BlogController::class, 'certificateCreate'])->name('certificate.create');
    Route::post('/admin/certificate/store', [BlogController::class, 'certificateStore'])->name('certificate.store');
    Route::get('/admin/certificate/edit/{id}', [BlogController::class, 'certificateEdit'])->name('certificate.edit');
    Route::get('/admin/certificate/data', [BlogController::class, 'getCertificateData'])->name('admin.certificate.data');
    Route::post('/admin/certificate/update-status', [BlogController::class, 'certificateUpdateStatus'])->name('admin.certificate.updateStatus');
    Route::put('/admin/certificate/update/{id}', [BlogController::class, 'certificateUpdate'])->name('certificate.update');
    Route::delete('/admin/certificate/delete/{id}', [BlogController::class, 'certificateDelete'])->name('certificate.delete');
    //web_settings
    Route::get('/admin/websettings', [BlogController::class, 'websettings'])->name('websettings');
    Route::get('/admin/websettings/create', [BlogController::class, 'websettingsCreate'])->name('websettings.create');
    Route::post('/admin/websettings/store', [BlogController::class, 'websettingsStore'])->name('websettings.store');
    Route::get('/admin/websettings/edit/{id}', [BlogController::class, 'websettingsEdit'])->name('websettings.edit');
    Route::get('/admin/websettings/data', [BlogController::class, 'getwebsettingsData'])->name('admin.websettings.data');
    Route::post('/admin/websettings/update-status', [BlogController::class, 'websettingsUpdateStatus'])->name('admin.websettings.updateStatus');
    Route::put('/admin/websettings/update/{id}', [BlogController::class, 'websettingsUpdate'])->name('websettings.update');
    Route::delete('/admin/websettings/delete/{id}', [BlogController::class, 'websettingsDelete'])->name('websettings.delete');
    //users_details
    Route::get('/admin/users', [BlogController::class, 'users'])->name('users');
    Route::get('/admin/users/data', [BlogController::class, 'getusersData'])->name('admin.users.data');
    Route::get('/admin/users/edit/{id}', [BlogController::class, 'usersEdit'])->name('users.edit');
    Route::delete('/admin/users/delete/{id}', [BlogController::class, 'usersDelete'])->name('users.delete');
    //contact message details
    Route::get('/admin/contact-message', [BlogController::class, 'contactMessageView'])->name('admin.contact.message.view');

    Route::get('/admin/contact-message-data', [BlogController::class, 'contactMessageData'])->name('admin.contact.message');
    //donation  route 
    Route::get('/admin/donation', [BlogController::class, 'donation'])->name('admin.donation');
    Route::get('/admin/donation-data', [BlogController::class, 'donationData'])->name('admin.donation.data');
    // Print PDF dynamically
    Route::get('/donations/{id}/print', [BlogController::class, 'printCertificate'])->name('donation.print');

    // Send PDF dynamically via email or WhatsApp
    Route::post('/donations/{id}/send', [BlogController::class, 'sendCertificate'])->name('donation.send');
    //youtube video 
    Route::get('/admin/youtub-video-url', [BlogController::class, 'frontvideo'])->name('admin.video');
    Route::get('/admin/video/data/', [BlogController::class, 'getVideoData'])->name('admin.video.data');
    Route::get('/admin/videos/create', [BlogController::class, 'createVideo'])->name('admin.video.create');
    Route::post('/admin/videos', [BlogController::class, 'storeVideo'])->name('admin.video.store');
    Route::get('/admin/videos/{id}/edit', [BlogController::class, 'editVideo'])->name('admin.video.edit');
    Route::put('admin/videos/{id}', [BlogController::class, 'updateVideo'])->name('admin.video.update');
    Route::delete('admin/videos/delete/{id}', [BlogController::class, 'destroyVideo'])->name('admin.video.delete');



});

require __DIR__ . '/auth.php';