
<?php $__env->startSection('content'); ?>
<?php
    $webSetting = \App\Models\Websettings::first();
?>

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Web Settings</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                  <?php if(!$webSetting || $webSetting->status === 'Inactive'): ?>
    <li class="breadcrumb-item">
        <a href="<?php echo e(route('websettings.create')); ?>" class="btn btn-info">Add Web Settings</a>
    </li>
<?php endif; ?>

                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Web Settings</h1>


                <?php if(Session::has('status')): ?>
                    <p class="alert alert-success"><?php echo e(Session::get('status')); ?></p>
                <?php endif; ?>
                <table id="categoryTable" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Logo</th>
                            <th>Company Name</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>

            </div>
        </div>

    </div>


    <?php $__env->startPush('scripts'); ?>
        <script>
            $(document).ready(function () {
                $('#categoryTable').DataTable({
                    autoWidth: true, // Let DataTables calculate column widths
                    responsive: true, // Optional, better behavior on small screens
                    processing: true,
                    serverSide: false, // optional for small datasets
                    ajax: '<?php echo e(route("admin.websettings.data")); ?>',
                    order: [],
                    columns: [
                        { data: 0 },
                        { data: 1 },
                        { data: 2 },
                        { data: 3 },
                        { data: 4 },
                    ]
                });
            });
        </script>
        <script>
            $(document).on('change', '.websettings-status', function (e) {
                e.preventDefault();

                let id = $(this).data('id');
                let status = $(this).val();

                $.ajax({
                    url: "<?php echo e(route('admin.websettings.updateStatus')); ?>",
                    type: "POST",
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        id: id,
                        status: status
                    },
                    success: function (response) {
                        Swal.fire({
                            title: 'Status Updated',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'OK'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                location.reload();
                            }
                        });
                    },
                    error: function (xhr) {
                        Swal.fire({
                            title: 'Error',
                            text: 'Something went wrong!',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                });
            });
        </script>
        <script>
            $(document).on('click', '.editBtn', function () {
                let id = $(this).data('id');
                window.location.href = 'websettings/edit/' + id;
            });
        </script>
        <script>
            $(document).on('click', '.deleteBtn', function () {
                const categoryId = $(this).data('id');

                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: `/admin/websettings/delete/${categoryId}`,
                            type: 'DELETE',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>'
                            },
                            success: function (response) {
                                Swal.fire(
                                    'Deleted!',
                                    response.message,
                                    'success'
                                ).then(() => {
                                    location.reload();
                                });
                            },
                            error: function () {
                                Swal.fire(
                                    'Error!',
                                    'There was a problem deleting the web details.',
                                    'error'
                                );
                            }
                        });
                    }
                });
            });
        </script>


    <?php $__env->stopPush(); ?>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Megatask Technology\Documents\xampp\htdocs\laravel-project\resources\views/admin/websettings.blade.php ENDPATH**/ ?>