<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>80G Donor Certificate</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />

    <style>
        body {
            background-color: #ffffff;
            font-family: 'Segoe UI', sans-serif;
        }

        .certificate {
            max-width: 850px;
            margin: 40px auto;
            background: #fff;
            padding: 40px;
            border-radius: 8px;

        }

        .logo {
            height: 70px;
        }

        .certificate-title {
            font-weight: bold;
            font-size: 24px;
            margin-top: 10px;
            text-decoration: underline;
        }

        .info-text {
            margin-top: 20px;
            font-size: 16px;
        }

        .footer-note {
            font-style: italic;
            margin-top: 40px;
            font-size: 14px;
        }

        .pan-info {
            margin-top: 10px;
            font-weight: bold;
            font-size: 14px;
        }

        .org-contact {
            margin-top: 20px;
            font-size: 15px;
            line-height: 1.7;
        }

        .signature-block {
            margin-top: 50px;
            font-size: 15px;
            text-align: right;
        }

        .signature-line {
            border-top: 1px solid #000;
            width: 250px;
            margin-top: 40px;
        }

        @media print {
            body {
                background: #fff !important;
                -webkit-print-color-adjust: exact;
                color-adjust: exact;
            }

            .certificate {
                box-shadow: none !important;
                border-radius: 0 !important;
                margin: 0 auto !important;
                padding: 20px !important;
                width: 100% !important;
                background-color: #fff !important;
            }

            .certificate-title {
                display: none !important;
            }

            header,
            footer {
                display: none !important;
            }

            img.logo {
                display: inline !important;
                visibility: visible !important;
                -webkit-filter: none !important;
                filter: none !important;
            }
        }
    </style>
</head>

<body>

    <div class="certificate text-center">
        
        <img src="<?php echo e(public_path('uploads/websettings/websettings_1748001562.png')); ?>" alt="IFF Logo" class="logo"
            class="text-center" />
        <div class="certificate-title">Certificate under Section 80G of the Income Tax Act, 1961</div>

        <div class="text-start mt-4">
            <p><strong>Name.:</strong> <?php echo e($donation->first_name); ?></p>
            <p><strong>Date:</strong> <?php echo e(\Carbon\Carbon::parse($donation->created_at)->format('d F Y')); ?></p>

            <p class="info-text">
                This is to certify that a donation of INR<strong> <?php echo e(number_format($donation->amount, 2)); ?></strong>
                has
                been received
                from
                <strong><?php echo e($donation->first_name); ?></strong> on <strong>
                    <?php echo e(\Carbon\Carbon::parse($donation->created_at)->format('d F Y')); ?></strong> through
                <strong>UPI</strong> (RazorPay
                Payment ID:
                <em>pay_Ge6SX9VNqALXUG</em>) towards the corpus of Internet Freedom Foundation.
            </p>

            <p class="info-text">
                This donation is eligible for deduction under section 80G of the Income Tax Act, 1961.
                No goods or services were provided in exchange for this donation.
            </p>

            <div class="org-contact">
                <strong>Internet Freedom Foundation</strong><br />
                E-215, Third Floor, East of Kailash<br />
                New Delhi - 110065, India<br />
                Email: info@internetfreedom.in
            </div>

            <p class="pan-info text-center mt-4">
                PAN: BBBTI3374C<br />
                80G Reg. No: NQ.CIT(E)2018-19/DEL-IE28615-27062018/10087<br />
                Effective from: <?php echo e(\Carbon\Carbon::parse($donation->created_at)->format('d F Y')); ?>

            </p>

            <div class="signature-block">
                For Internet Freedom Foundation
                <div class="signature-line"></div>
                <span>Authorized Signatory</span>
            </div>

            <p class="footer-note text-center mt-4">
                This is a computer-generated certificate and does not require a physical signature.
            </p>
        </div>
    </div>

</body>

</html><?php /**PATH D:\lampp\htdocs\ankit_laravel\resources\views/admin/certificate-layout.blade.php ENDPATH**/ ?>