
<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Edit Certificate</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('certificate')); ?>">Certificate</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Edit Certificate</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                    <form class="forms-sample" action="<?php echo e(route('certificate.update', $certificate->_id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <div class="form-group">
                        <label for="exampleInputName1">Title</label>
                        <input type="text" class="form-control" id="exampleInputName1" placeholder="Enter Heading"
                            name="title" value="<?php echo e(old('title', $certificate->title)); ?>">
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-group">
                        <label for="certificate_image"> </label>
                        <input type="file" name="certificate_image" id="certificate_image" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'preview_certificate')">
                        <small class="text-muted">Recommended size: 500x500 px</small>
                        <br>
                        <img src="<?php echo e(asset('uploads/certificates/' . $certificate->certificate_image)); ?>" id="preview_certificate" class="img-fluid mt-2" style="max-height: 200px;">
                    </div>
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description"
                            vlaue="<?php echo e(old('description')); ?>"><?php echo e(old('description', $certificate->description)); ?></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>
                    
                    <div class="form-group">
                        <label for="is_feature">Is Feature</label>
                        <select class="form-select" id="is_feature" name="is_feature">
                            <option value="Active" <?php echo e($certificate->is_feature == 'Active' ? 'selected' : ''); ?>>Active</option>
                            <option value="Inactive" <?php echo e($certificate->is_feature == 'Inactive' ? 'selected' : ''); ?>>Inactive</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-select" id="status" name="status">
                            <option value="Active" <?php echo e($certificate->status == 'Active' ? 'selected' : ''); ?>>Active</option>
                            <option value="Inactive" <?php echo e($certificate->status == 'Inactive' ? 'selected' : ''); ?>>Inactive</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Update Certificate</button>
                </form>
            </div>
        </div>
    </div>


    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/websdiix/ankityadavfoundation.org/resources/views/admin/certificate-edit.blade.php ENDPATH**/ ?>