
<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title"> Blogs</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('blog.create')); ?>" class="btn btn-info">Add Blog</a></li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Blogs</h1>


                <?php if(Session::has('status')): ?>
                    <p class="alert alert-success"><?php echo e(Session::get('status')); ?></p>
                <?php endif; ?>
                <table id="blogsTable" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Title</th>
                            <th>Slug</th>

                            <th>Is-Feature</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>

            </div>
        </div>

    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            $(document).ready(function () {
                $('#blogsTable').DataTable({
                    autoWidth: true, // Let DataTables calculate column widths
                    responsive: true, // Optional, better behavior on small screens
                    processing: true,
                    serverSide: false, // optional for small datasets
                    ajax: '<?php echo e(route("admin.blogs.data")); ?>',
                    order: [],
                    columns: [
                        { data: 0 },
                        { data: 1 },
                        { data: 2 },
                        { data: 3 },
                        { data: 4 }

                    ]
                });
            });
        </script>
        <script>
            $(document).on('change', '.blog-status', function (e) {
                e.preventDefault();

                let id = $(this).data('id');
                let isFeature = $(this).val();

                $.ajax({
                    url: "<?php echo e(route('admin.blog.updateFeatureStatus')); ?>", // 🔁 Make sure this route exists
                    type: "POST",
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        id: id,
                        is_feature: isFeature
                    },
                    success: function (response) {
                        Swal.fire({
                            title: 'Feature Updated',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'OK'
                        });
                    },
                    error: function () {
                        Swal.fire({
                            title: 'Error',
                            text: 'Something went wrong!',
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                });
            });
            //delete 
            $(document).on('click', '.deleteBtn', function () {
                var id = $(this).data('id');

                Swal.fire({
                    title: 'Are you sure?',
                    text: "This blog and its images will be permanently deleted.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: '/admin/blog/delete/' + id,
                            type: 'DELETE',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>'
                            },
                            success: function (response) {
                                Swal.fire(
                                    'Deleted!',
                                    response.message,
                                    'success'
                                );
                                $('#blogsTable').DataTable().ajax.reload();
                            },
                            error: function () {
                                Swal.fire(
                                    'Error!',
                                    'There was a problem deleting the blog.',
                                    'error'
                                );
                            }
                        });
                    }
                });
            });
            $(document).on('click', '.editBtn', function () {
                var id = $(this).data('id');
                window.location.href = '/admin/blog/edit/' + id;
            })

        </script>

    <?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\lampp\htdocs\ankit\resources\views/admin/blogs.blade.php ENDPATH**/ ?>