
<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">About Image Upload</h3>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('web.about.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    
                    <div class="form-group">
                        <label for="market_maestro_image">Market Maestro Image (610x691 px)</label>
                        <input type="file" name="market_maestro_image" id="market_maestro_image" class="form-control"
                            accept="image/*" onchange="previewImage(this, 'market_banner')">
                        <small class="text-muted">Recommended size: 1920x803 px</small>
                        <img id="market_banner" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>



                    
                    <div class="form-group">
                        <label>Foundation Images (Each: 610x691 px)</label>

                        <div class="mb-2">
                            <label for="foundation_image1">Foundation Image 1</label>
                            <input type="file" name="foundation_image1" id="foundation_image1" class="form-control"
                                accept="image/*" onchange="previewImage(this, 'preview_foundation_1')">
                            <img id="preview_foundation_1" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                        </div>

                        <div class="mb-2">
                            <label for="foundation_image2">Foundation Image 2</label>
                            <input type="file" name="foundation_image2" id="foundation_image2" class="form-control"
                                accept="image/*" onchange="previewImage(this, 'preview_foundation_2')">
                            <img id="preview_foundation_2" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                        </div>

                        <div class="mb-2">
                            <label for="foundation_image3">Foundation Image 3</label>
                            <input type="file" name="foundation_image3" id="foundation_image3" class="form-control"
                                accept="image/*" onchange="previewImage(this, 'preview_foundation_3')">
                            <img id="preview_foundation_3" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                        </div>


                    </div>



                    
                    <div class="form-group">
                        <label>Founder Images (Each: 610x691 px)</label>

                        <div class="mb-2">
                            <label for="Founder_image1">Founder Image 1</label>
                            <input type="file" name="Founder_image1" id="Founder_image1" class="form-control"
                                accept="image/*" onchange="previewImage(this, 'preview_Founder_1')">
                            <img id="preview_Founder_1" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                        </div>

                        <div class="mb-2">
                            <label for="Founder_image2">Founder Image 2</label>
                            <input type="file" name="Founder_image2" id="Founder_image2" class="form-control"
                                accept="image/*" onchange="previewImage(this, 'preview_Founder_2')">
                            <img id="preview_Founder_2" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                        </div>




                    </div>

                    <button type="submit" class="btn btn-primary">Upload Images</button>
                </form>
            </div>
        </div>
    </div>


    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\lampp\htdocs\ankit_laravel\resources\views/admin/web-about.blade.php ENDPATH**/ ?>