
<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title"> Donations</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>" class="btn btn-info">Dashboard</a></li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Donations</h1>


                <?php if(Session::has('status')): ?>
                    <p class="alert alert-success"><?php echo e(Session::get('status')); ?></p>
                <?php endif; ?>
                <table id="donationTable" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>S.No</th>
                            <th>Name</th>
                            <th>phone</th>
                            <th>Amount</th>
                            <th>Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>

            </div>
        </div>

    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            $(document).ready(function () {
                $('#donationTable').DataTable({
                    autoWidth: true,
                    responsive: true,
                    processing: true,
                    serverSide: false, // okay for small datasets
                    ajax: '<?php echo e(route("admin.donation.data")); ?>',
                    order: [],
                    columns: [
                        { data: 'sl_no' },
                        { data: 'name' },
                        { data: 'phone' },
                        { data: 'amount' },
                        { data: 'payment_date' },
                        { data: 'actions', orderable: false, searchable: false }
                    ]
                });
            });
        </script>






    <?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\lampp\htdocs\ankit\resources\views/admin/donation.blade.php ENDPATH**/ ?>