
<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title"><?php echo e(isset($video) ? 'Edit' : 'Add'); ?> Video</h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.video')); ?>">Video</a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(isset($video) ? 'Edit' : 'Add'); ?> Video</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(isset($video) ? route('admin.video.update', $video->_id) : route('admin.video.store')); ?>"
                    method="POST">
                    <?php echo csrf_field(); ?>
                    <?php if(isset($video)): ?>
                        <?php echo method_field('PUT'); ?>
                    <?php endif; ?>

                    <div class="form-group">
                        <label for="video_link">Video URL</label>
                        <input type="url" name="video_link" id="video_link" class="form-control"
                            placeholder="Enter YouTube/Vimeo URL" value="<?php echo e(old('video_link', $video->video_link ?? '')); ?>"
                            required>
                        <?php $__errorArgs = ['video_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group">
                        <label for="is_feature">Is Feature</label>
                        <select name="is_feature" id="is_feature" class="form-select">
                            <option value="1" <?php echo e(old('is_feature', $video->is_feature ?? '') == 1 ? 'selected' : ''); ?>>Yes
                            </option>
                            <option value="0" <?php echo e(old('is_feature', $video->is_feature ?? '') == 0 ? 'selected' : ''); ?>>No
                            </option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="status">Status</label>
                        <select name="status" id="status" class="form-select">
                            <option value="Active" <?php echo e(old('status', $video->status ?? '') == 'Active' ? 'selected' : ''); ?>>
                                Active</option>
                            <option value="Inactive" <?php echo e(old('status', $video->status ?? '') == 'Inactive' ? 'selected' : ''); ?>>Inactive</option>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-primary"><?php echo e(isset($video) ? 'Update' : 'Submit'); ?></button>
                    <a href="<?php echo e(route('admin.video')); ?>" class="btn btn-secondary">Back</a>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\lampp\htdocs\ankit\resources\views/admin/video-create.blade.php ENDPATH**/ ?>