
<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title"> Blog Edit </h3>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('blog')); ?>">Blog</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Edit Blog</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-body">
                <h1 class="card-title mb-4">Edit</h1>

                <form class="forms-sample" method="POST" action="<?php echo e(route('blog.update', $blog->_id)); ?>"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?> <!-- Important for PUT method -->

                    <div class="form-group">
                        <label for="exampleInputName1">Title</label>
                        <input type="text" class="form-control" name="title" value="<?php echo e(old('title', $blog->title)); ?>">
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group">
                        <label for="slug">Slug</label>
                        <input type="text" class="form-control" id="slug" name="slug" value="<?php echo e(old('slug', $blog->slug)); ?>"
                            readonly>
                    </div>

                    <div class="form-group">
                        <label for="exampleSelectGender">Category</label>
                        <select class="form-select" name="category_id">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->_id); ?>" <?php echo e($category->_id == $blog->category_id ? 'selected' : ''); ?>>
                                    <?php echo e($category->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Feature Image</label>
                        <input type="file" name="image" class="file-upload-default" id="fileInput">

                        <div class="input-group col-xs-12">
                            <input type="text" class="form-control file-upload-info" disabled placeholder="Upload Image">
                            <span class="input-group-append">
                                <button class="file-upload-browse btn btn-gradient-primary py-3" type="button"
                                    onclick="document.getElementById('fileInput').click();">Upload</button>
                            </span>
                        </div>

                        <div id="preview" style="margin-top: 10px;">
                            <?php if(!empty($blog->image)): ?>
                                <img id="previewImage" src="<?php echo e(asset('uploads/blog/' . $blog->image)); ?>" alt="Preview"
                                    style="max-width: 200px; border: 1px solid #ccc; padding: 5px;" />
                            <?php else: ?>
                                <img id="previewImage" src="" alt="Preview" style="max-width: 200px; display: none;" />
                            <?php endif; ?>
                        </div>

                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>


                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description"
                            name="description"><?php echo e(old('description', $blog->description)); ?></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group">
                        <label for="user_id">Author</label>
                        <select class="form-select" id="user_id" name="author">
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>" <?php echo e($blog->author == $user->id ? 'selected' : ''); ?>>
                                    <?php echo e($user->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="tag">Tag</label>
                        <input type="text" class="form-control" id="tag" name="tag" value="<?php echo e(old('tag', $blog->tag)); ?>">
                    </div>

                    <div class="form-group">
                        <label for="schedule_date">Schedule Blog Publish Date & Time</label>
                        <input type="datetime-local" class="form-control" id="schedule_date" name="schedule_date"
                            value="<?php echo e(old('schedule_date', \Carbon\Carbon::parse($blog->schedule_date)->format('Y-m-d\TH:i'))); ?>">
                    </div>

                    <div class="form-group">
                        <label for="is_feature">Is Feature</label>
                        <select class="form-select" id="is_feature" name="is_feature">
                            <option value="Active" <?php echo e($blog->is_feature === 'Active' ? 'selected' : ''); ?>>Active</option>
                            <option value="Inactive" <?php echo e($blog->is_feature === 'Inactive' ? 'selected' : ''); ?>>Inactive
                            </option>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-gradient-primary me-2">Update</button>
                    <a href="<?php echo e(route('blog')); ?>" class="btn btn-light">Cancel</a>
                </form>

            </div>
        </div>

    </div>



<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const fileInput = document.getElementById('fileInput');
            const previewImage = document.getElementById('previewImage');
            const fileUploadInfo = document.querySelector('.file-upload-info');

            if (fileInput && previewImage && fileUploadInfo) {
                fileInput.addEventListener('change', function () {
                    const file = this.files[0];
                    if (file) {
                        const reader = new FileReader();

                        reader.onload = function (e) {
                            previewImage.setAttribute('src', e.target.result);
                            previewImage.style.display = 'block';
                            fileUploadInfo.value = file.name;
                        }

                        reader.readAsDataURL(file);
                    }
                });
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/websdiix/ankityadavfoundation.org/resources/views/admin/blog-edit.blade.php ENDPATH**/ ?>