
<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Edit Contact Image Upload</h3>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('web.donation.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    
                    <div class="form-group">
                        <label for="donation_image">Donation Image (2256x3384 px)</label>
                        <input type="file" name="donation_image" id="donation_image" class="form-control" accept="image/*"
                            onchange="previewImage(this, 'preview_donation')">
                        <small class="text-muted">Recommended size: 2256x3384 px</small>

                        
                        <?php if(!empty($donation->donation_image)): ?>
                            <div class="mt-2">
                                <label>Current Image:</label><br>
                                <img src="<?php echo e(asset('uploads/donation/' . $donation->donation_image)); ?>" class="img-fluid"
                                    style="max-height: 200px;">
                            </div>
                        <?php endif; ?>

                        
                        <img id="preview_donation" class="img-fluid mt-2 d-none" style="max-height: 200px;">
                    </div>

                    <button type="submit" class="btn btn-primary">Update Image</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\lampp\htdocs\ankit\resources\views/admin/web-donation-edit.blade.php ENDPATH**/ ?>