
<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">Edit Project Images</h3>
        </div>

        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('web.project.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    
                    <?php for($i = 1; $i <= 6; $i++): ?>
                        <div class="form-group">
                            <label for="project_image<?php echo e($i); ?>">Project Image <?php echo e($i); ?> (376x242 px)</label>
                            <input type="file" name="project_image<?php echo e($i); ?>" id="project_image<?php echo e($i); ?>" class="form-control"
                                accept="image/*" onchange="previewImage(this, 'preview_project_<?php echo e($i); ?>')">

                            <?php
                                $imageField = 'project_image' . $i;
                            ?>

                            <?php if(!empty($data->$imageField)): ?>
                                <p class="mt-2">Current:
                                    <img src="<?php echo e(asset('uploads/project/' . $data->$imageField)); ?>" class="img-fluid"
                                        style="max-height: 150px;">
                                </p>
                            <?php endif; ?>

                            <img id="preview_project_<?php echo e($i); ?>" class="img-fluid mt-2 d-none" style="max-height: 150px;">
                        </div>
                    <?php endfor; ?>

                    <button type="submit" class="btn btn-primary">Update Images</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        function previewImage(input, previewId) {
            const preview = document.getElementById(previewId);
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = e => {
                    preview.src = e.target.result;
                    preview.classList.remove('d-none');
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\lampp\htdocs\ankit\resources\views/admin/web-project-edit.blade.php ENDPATH**/ ?>