<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <?php if($websettings): ?>
            <title><?php echo e($title ?? 'Default Title'); ?> | <?php echo e($websettings->company_name); ?></title>
            <link rel=icon href="assets/img/favicon.png" sizes="20x20" type="image/png">

            <!-- Stylesheet -->

            <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/fontawesome.min.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/flaticon.min.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/nice-select.min.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/magnific.min.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/spacing.min.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/slick.min.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/style.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/css/sweetalert2.css')); ?>">


        </head>

        <body class='sc5'>

            <!-- preloader area start -->
            <!-- <div class="preloader" id="preloader">
                                                                                                                <div class="preloader-inner">
                                                                                                                    <div class="spinner">
                                                                                                                        <div class="dot1"></div>
                                                                                                                        <div class="dot2"></div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </div> -->
            <!-- preloader area end -->


            <div class="navbar-top pt-15 pb-10 bgc-black navtop--one">
                <div class="container">
                    <div class="navtop-inner">
                        <ul class="topbar-left">
                            <li><span>Hi</span>, Good Afternoon, Welcome! </li>
                            <li><i class="flaticon-pin"></i> <?php echo e($websettings->company_address); ?></li>
                        </ul>
                        <ul class="topbar-right">
                            <li class="social-area">
                                <span>Follow Us - </span>
                                <a href="<?php echo e($websettings->facebook_link); ?>" target="_blank" rel="noopener noreferrer">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                                <a href="<?php echo e($websettings->twitter_link); ?>" target="_blank" rel="noopener noreferrer">
                                    <i class="fab fa-twitter"></i>
                                </a>
                                <a href="<?php echo e($websettings->insta_link); ?>" target="_blank" rel="noopener noreferrer">
                                    <i class="fab fa-instagram"></i>
                                </a>
                                <a href="<?php echo e($websettings->linkdin_link); ?>" target="_blank" rel="noopener noreferrer">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <nav class="navbar py-30 navbar--one navbar-area navbar-expand-lg">
                <div class="container nav-container navbar-bg">
                    <div class="responsive-mobile-menu">
                        <button class="menu toggle-btn d-block d-lg-none" data-target="#Iitechie_main_menu"
                            aria-expanded="false" aria-label="Toggle navigation">
                            <span class="icon-left"></span>
                            <span class="icon-right"></span>
                        </button>
                    </div>
                    <div class="logo">
                        <a href="<?php echo e(route('home')); ?>"><img
                                src="<?php echo e(asset('uploads/websettings/' . $websettings->websettings_image)); ?>" alt="img"
                                style="width:10%;"></a>
                    </div>
                    <div class="nav-right-part nav-right-part-mobile">
                        <a class="search-bar-btn" href="#">
                            <i class="flaticon-magnifying-glass"></i>
                        </a>
                    </div>
                    <div class="collapse navbar-collapse" id="Iitechie_main_menu">
                        <ul class="navbar-nav menu-open text-lg-end">

                            <li class="menu">
                                <a href="<?php echo e(route('home')); ?>">Home</a>
                            </li>
                            <li class="menu-item-has-children">
                                <a href="#">About Us</a>
                                <ul class="sub-menu">
                                    <li><a href="<?php echo e(route('about.foundation')); ?>">About the Foundation</a></li>
                                    <li><a href="<?php echo e(route('about.founder')); ?>">About Founder</a></li>
                                    <li><a href="<?php echo e(route('about.market')); ?>">Market Maestro</a></li>

                                </ul>
                            </li>
                            <li class="menu">
                                <a href="<?php echo e(route('about.project')); ?>">Project</a>
                            </li>
                            <li class="menu">
                                <a href="<?php echo e(route('about.blogs')); ?>">Blog</a>
                            </li>
                            <!-- <li class="menu">
                                                                                                                            <a href="careers.php">Careers</a>
                                                                                                                        </li> -->
                            <li class="menu">
                                <a href="<?php echo e(route('about.contact')); ?>">Contact Us</a>
                            </li>

                        </ul>
                    </div>
                    <div class="nav-right-part nav-right-part-desktop">

                        <a class="btn btn--style-two" href="<?php echo e(route('about.donate')); ?>">Donate Now</a>
                    </div>
                </div>
            </nav>

            <?php echo $__env->yieldContent('content'); ?>

            <footer class="footer-area overlay text-white pt-60 bgs-cover"
                style="background-image: url(<?php echo e(asset('assets/front/img/footer/footer-bg.jpg')); ?>);">
                <div class="container">
                    <div class="row justify-content-between">
                        <div class="col-lg-4 col-md-6 col-sm-8">
                            <div class="widget widget_about">
                                <div class="logo_footer mb-25">
                                    <a href="<?php echo e(route('home')); ?>">
                                        <img src="<?php echo e(asset('uploads/websettings/' . $websettings->websettings_image)); ?>"
                                            alt="Logo">
                                    </a>
                                </div>
                                <p>The primary mission of the Ankit Yadav Foundation is to bridge the opportunity gap that
                                    exists in
                                    our society.Through carefully designed programs, the foundation addresses both the immediate
                                    needs and long-term development goals of the communities.</p>
                                <div class="social-style-one pt-20">
                                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                                    <a href="#"><i class="fab fa-twitter"></i></a>
                                    <a href="#"><i class="fab fa-linkedin-in"></i></a>

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-3 col-sm-4 col-6">
                            <div class="widget widget_nav_menu">
                                <h5 class="widget-title">Quick Link</h5>
                                <ul>
                                    <li><i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp; <a
                                            href="<?php echo e(route('home')); ?>">Home</a>
                                    </li>
                                    <li> <i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp;<a
                                            href="<?php echo e(route('about.founder')); ?>">
                                            About
                                            Us</a></li>
                                    <li><i class="fa fa-arrow-right" aria-hidden="true"></i> &nbsp;<a
                                            href="<?php echo e(route('about.project')); ?>">Project</a>
                                    </li>
                                    <li><i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp; <a
                                            href="<?php echo e(route('about.blogs')); ?>">Blog</a></li>
                                    <li><i class="fa fa-arrow-right" aria-hidden="true"></i> &nbsp;<a
                                            href="<?php echo e(route('about.donate')); ?>">Donation</a>
                                    </li>

                                    <li><i class="fa fa-arrow-right" aria-hidden="true"></i>&nbsp; <a
                                            href="<?php echo e(route('about.contact')); ?>">Contact
                                            Us</a>
                                    </li>

                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-3 col-sm-4 col-6">
                            <div class="widget widget_nav_menu">
                                <h5 class="widget-title">Get In Touch</h5>
                                <ul>
                                    <li><a href="#"><i class="fa fa-location-arrow" aria-hidden="true"></i>
                                            <?php echo e($websettings->company_address); ?> </a></li>
                                    <li><a href="mailto:<?php echo e($websettings->company_email); ?>"><i class="fa fa-envelope"
                                                aria-hidden="true"></i>
                                            <?php echo e($websettings->company_email); ?></a></li>
                                    <li><a href="tel:<?php echo e($websettings->company_phone); ?>"><i class="fa fa-phone"
                                                aria-hidden="true"></i> <?php echo e($websettings->company_phone); ?></a></li>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom mt-10">
                    <div class="container">
                        <div class="footer-bottom__inner">
                            <div class="donate-by">
                                <span>Designed and Developed by : Digital Websynation LLP</span>
                            </div>
                            <div class="copyright">
                                <p>Copyright 2025 All Right Reserved</p>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- footer area end -->

            <!-- back to top area start -->
            <div class="back-to-top">
                <span class="back-top"><i class="fa fa-angle-up"></i></span>
            </div>
            <!-- back to top area end -->

    <?php endif; ?>

    <!-- all plugins here -->
    <script src="<?php echo e(asset('assets/front/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/circle-progress.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/skill.bars.jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/magnific.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/appear.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/isotope.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/imageload.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/slick.min.js')); ?>"></script>

    <!-- main js  -->
    <script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/sweetalert2.js')); ?>"></script>
    <?php echo $__env->yieldPushContent('scripts'); ?>

</body>

</html><?php /**PATH D:\lampp\htdocs\ankit_laravel\resources\views/layouts/attach.blade.php ENDPATH**/ ?>