<!-- Blog Start -->
<?php
// Include the recipe data
include "data/quickfamily.php";

// Check if $quickfamily is set, is an array, and has at least some data
if (isset($quickfamily) && is_array($quickfamily) && count($quickfamily) > 0) {
?>
    <div class="container-xxl py-5">
        <div class="container">
            <div class="section-header text-center mx-auto mb-5 wow fadeInUp" data-wow-delay="0.1s" style="max-width: 700px;">
                <h1 class="display-5 mb-3">Quick Family Recipe</h1>
                <p>Find a range of tasty and quick vegan recipes that are ideal for hectic days.</p>
            </div>

            <div class="row g-4">
                <?php
                // Initialize a counter
                $count = 0;

                // Loop through the $quickfamily array but only show 6 items (limit to 6)
                foreach ($quickfamily as $recipe_item) {
                    if ($count >= 6) {
                        break; // Exit the loop after 6 items
                    }
                ?>
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                        <img class="img-fluid inner" src="<?php echo $recipe_item['image']; ?>" alt="Recipe Image" height="297px" width="408px">
                        <div class="bg-light p-4">
                            <a class="d-block h5 lh-base mb-4" href="recipe-details.php?recipe_id=<?php echo $recipe_item['id']; ?>">
                                <?php echo $recipe_item['name']; ?>
                            </a>
                        </div>
                    </div>
                <?php
                    $count++; // Increment the counter after displaying a recipe
                }
                ?>
            </div>
        </div>
    </div>
<?php
} else {
    // Handle the case when $quickfamily is not set or is not an array
    echo "<p class='text-center'>No quick family recipes available.</p>";
}
?>
<!-- Blog End -->