<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Reci World || Easy Dessert Recipe</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <?php include "include/link.php" ?>
</head>

<body>
    <?php include "include/header.php" ?>

    <div class="container-fluid page-header mb-5 wow fadeIn" data-wow-delay="0.1s" style="visibility: visible; animation-delay: 0.1s; animation-name: fadeIn;">
        <div class="container">
            <h1 class="display-3 mb-3 slideInDown">Easy Dessert Recipe</h1>
            <nav aria-label="breadcrumb animated slideInDown">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a class="text-body" href="index.php">Home</a></li>
                    <li class="breadcrumb-item text-dark active" aria-current="page">Easy Dessert Recipe</li>
                </ol>
            </nav>
        </div>
    </div>

    <?php
    // Include the recipe data
    include "data/easydessert.php";
    // Check if $breakfast_recipes is set and is an array
    if (isset($easydessert) && is_array($easydessert) && count($easydessert) > 0) {
    ?>

        <div class="container-xxl py-5">
            <div class="container">
                <div class="section-header text-center mx-auto mb-5 wow fadeInUp" data-wow-delay="0.1s" style="max-width: 700px;">
                    <h1 class="display-5 mb-3">Easy Dessert Recipe</h1>
                    <p>Find a range of tasty and quick vegan recipes that are ideal for hectic days.</p>
                </div>

                <div class="row g-4">
                    <?php
                    // Loop through each recipe
                    foreach ($easydessert as $recipe_item) {
                    ?>
                        <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                            <img class="img-fluid inner" src="<?php echo $recipe_item['image']; ?>" alt="Recipe Image" height="297px" width="408px">
                            <div class="bg-light p-4">
                                <a class="d-block h5 lh-base mb-4" href="recipe-details.php?recipe_id=<?php echo $recipe_item['id']; ?>">
                                    <?php echo $recipe_item['name']; ?>
                                </a>
                            </div>
                        </div>
                    <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    <?php
    } else {
        // Handle the case when $breakfast_recipes is not set or is not an array
        echo "<p class='text-center'>No breakfast recipes available.</p>";
    }
    ?>

    <?php include "include/footer.php" ?>
</body>

</html>