<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Website Name || Recipe Details</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <?php include "include/link.php" ?>
</head>

<body>
    <?php include "include/header.php" ?>
    <?php
    // Include all recipe data files
    include "data/breakfast.php";
    include "data/quickbreackfast.php";
    include "data/healthybreakfast.php";
    include "data/vegakbreakfast.php";
    include "data/lowcardbreakfast.php";
    include "data/quickhealthy.php";
    include "data/quickvegan.php";
    include "data/quickfamily.php";
    include "data/easyquickrecipes.php";
    include "data/lowcalorie.php";
    include "data/lowcaloriechicken.php";
    include "data/lowcalorievegan.php";
    include "data/lowcarbfamily.php";
    include "data/500calorirecipe.php";
    include "data/quickbakes.php";
    include "data/quickcakes.php";
    include "data/easydessert.php";
    include "data/tray-bakes-recipes.php";
    include "data/leftover-recipes.php";
    include "data/leftover-chicken-recipes.php";
    include "data/leftover-pork-recipes.php";
    include "data/leftover-lamb-recipes.php";
    // Combine all recipes into a single array, preserving keys
    $all_recipes = $breakfast_recipes +
        $healthybreakfast +
        $quickbreackfast +
        $vegakbreakfast +
        $lowcardbreakfast +
        $quickhealthy +
        $quickvegan +
        $quickfamily +
        $easyquickrecipes +
        $lowcalorie +
        $lowcaloriechicken +
        $lowcalorievegan +
        $lowcarbfamily +
        $calorirecipes +
        $quickbakes +
        $quickcakes +
        $easydessert +
        $traybakes +
        $leftoverrecipes +
        $leftoverchicken +
        $leftoverpork +
        $leftoverlamb;



    // Check if a recipe ID is provided in the URL
    if (isset($_GET['recipe_id'])) {
        // Get the recipe ID from the URL
        $recipeId = $_GET['recipe_id'];

        // Check if the provided recipe ID exists in the combined recipe array
        if (array_key_exists($recipeId, $all_recipes)) {
            $recipe = $all_recipes[$recipeId];
    ?>
            <div class="container-fluid page-header mb-5 wow fadeIn" data-wow-delay="0.1s" style="visibility: visible; animation-delay: 0.1s; animation-name: fadeIn;">
                <div class="container">
                    <h1 class="display-3 mb-3  slideInDown">Recipe Details</h1>
                    <nav aria-label="breadcrumb animated slideInDown">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a class="text-body" href="index.php">Home</a></li>
                            <li class="breadcrumb-item text-dark active" aria-current="page"><?php echo $recipe['name']; ?></li>
                        </ol>
                    </nav>
                </div>
            </div>
            <div class="container-xxl py-5">
                <div class="container">
                    <div class="row g-5 ">
                        <div class="col-lg-6 wow fadeIn" data-wow-delay="0.1s" style="visibility: visible; animation-delay: 0.1s; animation-name: fadeIn;">
                            <div class="about-img position-relative overflow-hidden p-5 pe-0" style="top: 20px; position: sticky !important;">
                                <img class="img-fluid w-100" src="<?php echo $recipe['inner-image']; ?>" alt="<?php echo $recipe['name']; ?>">
                            </div>
                        </div>
                        <div class="col-lg-6 wow fadeIn " data-wow-delay="0.5s" style="visibility: visible; animation-delay: 0.5s; animation-name: fadeIn;" id="txt">
                            <h1 class="display-5 "><?php echo $recipe['name']; ?></h1>
                            <p class="mb-4"><?php echo $recipe['summary']; ?></p>
                            <!-- Optionally add a description -->
                            <h4>Ingredients</h4>
                            <?php foreach ($recipe['ingredients'] as $ingredient) : ?>
                                <p><i class="fa fa-check text-primary me-3"></i><?php echo $ingredient; ?></p>
                            <?php endforeach; ?>
                            <h4>Instructions</h4>
                            <!-- Corrected the second heading to "Instructions" -->
                            <?php foreach ($recipe['instructions'] as $instruction) : ?>
                                <p><i class="fa fa-check text-primary me-3"></i><?php echo $instruction; ?></p>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
    <?php
        } else {
            // Display an error message if the recipe ID is not found
            echo "<p>Recipe not found.</p>";
        }
    } else {
        // Display an error message if no recipe ID is provided
        echo "<p>No recipe ID provided.</p>";
    }
    ?>
    <?php include "include/footer.php" ?>